/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.messages;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.apache.plc4x.java.api.messages.PlcRequest;
import org.apache.plc4x.java.api.messages.PlcResponse;
import org.apache.plc4x.java.spi.messages.PlcProtocolMessage;

public class PlcRequestContainer<T extends PlcRequest, R extends PlcResponse>
implements PlcProtocolMessage {
    private final T request;
    private final CompletableFuture<R> responseFuture;

    public PlcRequestContainer(T request, CompletableFuture<R> responseFuture) {
        Objects.requireNonNull(request, "Request must not be null");
        Objects.requireNonNull(responseFuture, "Response future must not be null");
        this.request = request;
        this.responseFuture = responseFuture;
    }

    public T getRequest() {
        return this.request;
    }

    public CompletableFuture<R> getResponseFuture() {
        return this.responseFuture;
    }

    @Override
    public PlcProtocolMessage getParent() {
        return null;
    }

    public String toString() {
        return "PlcRequestContainer{request=" + this.request + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PlcRequestContainer)) {
            return false;
        }
        PlcRequestContainer that = (PlcRequestContainer)o;
        return Objects.equals(this.request, that.request) && Objects.equals(this.responseFuture, that.responseFuture);
    }

    public int hashCode() {
        return Objects.hash(this.request, this.responseFuture);
    }
}

