/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.values;

import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.api.types.PlcValueType;
import org.apache.plc4x.java.spi.codegen.WithOption;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.values.PlcSimpleValue;

public class PlcLDATE
extends PlcSimpleValue<LocalDate> {
    public static PlcLDATE of(Object value) {
        if (value instanceof LocalDate) {
            return new PlcLDATE((LocalDate)value);
        }
        if (value instanceof Long) {
            return new PlcLDATE(LocalDateTime.ofInstant(Instant.ofEpochSecond((Long)value), ZoneOffset.UTC).toLocalDate());
        }
        throw new PlcRuntimeException("Invalid value type");
    }

    public static PlcLDATE ofNanosecondsSinceEpoch(BigInteger nanosecondsSinceEpoch) {
        BigInteger epochSecond = nanosecondsSinceEpoch.divide(BigInteger.valueOf(1000000L));
        BigInteger nanoOfSecond = nanosecondsSinceEpoch.mod(BigInteger.valueOf(1000000L));
        return new PlcLDATE(LocalDateTime.ofEpochSecond(epochSecond.longValue(), nanoOfSecond.intValue(), ZoneOffset.of(ZoneOffset.systemDefault().getId())).toLocalDate());
    }

    public PlcLDATE(LocalDate value) {
        super(value, true);
    }

    public PlcLDATE(BigInteger nanosecondsSinceEpoch) {
        super(LocalDateTime.ofEpochSecond(nanosecondsSinceEpoch.longValue() / 1000000L, (int)(nanosecondsSinceEpoch.longValue() % 1000000L), ZoneOffset.of(ZoneOffset.systemDefault().getId())).toLocalDate(), true);
    }

    public PlcValueType getPlcValueType() {
        return PlcValueType.DATE;
    }

    public BigInteger getNanosecondsSinceEpoch() {
        Instant instant = this.getDateTime().toInstant(ZoneOffset.of(ZoneOffset.systemDefault().getId()));
        return BigInteger.valueOf(instant.getEpochSecond()).multiply(BigInteger.valueOf(1000000000L)).add(BigInteger.valueOf(instant.getNano()));
    }

    @Override
    public boolean isLong() {
        return true;
    }

    @Override
    public long getLong() {
        Instant instant = ((LocalDate)this.value).atStartOfDay(ZoneOffset.UTC).toInstant();
        return instant.toEpochMilli() / 1000L;
    }

    @Override
    public boolean isString() {
        return true;
    }

    @Override
    public String getString() {
        return ((LocalDate)this.value).toString();
    }

    @Override
    public boolean isDate() {
        return true;
    }

    @Override
    public LocalDate getDate() {
        return (LocalDate)this.value;
    }

    @Override
    public LocalDateTime getDateTime() {
        return ((LocalDate)this.value).atStartOfDay();
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @Override
    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        String valueString = ((LocalDate)this.value).toString();
        writeBuffer.writeString(this.getClass().getSimpleName(), valueString.getBytes(StandardCharsets.UTF_8).length * 8, valueString, WithOption.WithEncoding(StandardCharsets.UTF_8.name()));
    }
}

