/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.common.util;

import com.google.common.collect.Maps;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlExpression;
import org.apache.commons.jexl3.JexlFeatures;
import org.apache.commons.jexl3.MapContext;
import org.apache.hertzbeat.common.util.JexlCommonFunction;

public class JexlExpressionRunner {
    private static final String LOADER_NAME = "jexl-class-loader";
    private static final JexlEngine jexlEngine;

    public static Object evaluate(String expression, Map<String, Object> context) {
        MapContext jexlContext = new MapContext();
        for (Map.Entry<String, Object> entry : context.entrySet()) {
            jexlContext.set(entry.getKey(), entry.getValue());
        }
        return jexlEngine.createExpression(expression).evaluate((JexlContext)jexlContext);
    }

    public static Object evaluate(JexlExpression expression, Map<String, Object> context) {
        MapContext jexlContext = new MapContext();
        for (Map.Entry<String, Object> entry : context.entrySet()) {
            jexlContext.set(entry.getKey(), entry.getValue());
        }
        return expression.evaluate((JexlContext)jexlContext);
    }

    public static Object evaluate(String expression) {
        return jexlEngine.createExpression(expression).evaluate((JexlContext)new MapContext());
    }

    public static JexlExpression compile(String expression) {
        return jexlEngine.createExpression(expression);
    }

    static {
        LinkedHashMap functions = Maps.newLinkedHashMap();
        functions.put(null, new JexlCommonFunction());
        ClassLoader classLoader = new ClassLoader(){

            @Override
            public String getName() {
                return JexlExpressionRunner.LOADER_NAME;
            }
        };
        JexlFeatures features = new JexlFeatures();
        features.annotation(false).loops(false).pragma(false).methodCall(false).lambda(false).newInstance(false).register(false);
        jexlEngine = new JexlBuilder().charset(StandardCharsets.UTF_8).cache(256).loader(classLoader).features(features).strict(true).silent(false).stackOverflow(40).namespaces((Map)functions).create();
    }
}

