/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.common.cache.decorators;

import com.alibaba.nacos.common.cache.Cache;
import com.alibaba.nacos.common.cache.builder.CacheItemProperties;
import java.util.HashMap;
import java.util.concurrent.Callable;

public class AutoExpireCache<K, V>
implements Cache<K, V> {
    private long expireNanos;
    private Cache<K, V> delegate;
    private HashMap<K, CacheItemProperties> keyProp = new HashMap();

    public AutoExpireCache(Cache<K, V> delegate, long expireNanos) {
        this.expireNanos = expireNanos;
        this.delegate = delegate;
    }

    @Override
    public void put(K key, V val) {
        this.keyProp.put(key, this.cacheItemProperties());
        this.delegate.put(key, val);
    }

    @Override
    public V get(K key) {
        if (this.keyProp.get(key) != null && this.isExpire(this.keyProp.get(key))) {
            this.keyProp.remove(key);
            this.delegate.remove(key);
            return null;
        }
        return this.delegate.get(key);
    }

    @Override
    public V get(K key, Callable<? extends V> call) throws Exception {
        V cachedValue = this.get(key);
        if (null == cachedValue) {
            V v2 = call.call();
            this.put(key, v2);
            return v2;
        }
        return cachedValue;
    }

    @Override
    public V remove(K key) {
        this.keyProp.remove(key);
        return this.delegate.remove(key);
    }

    @Override
    public void clear() {
        this.keyProp.clear();
        this.delegate.clear();
    }

    @Override
    public int getSize() {
        return this.delegate.getSize();
    }

    private boolean isExpire(CacheItemProperties itemProperties) {
        if (itemProperties == null) {
            return true;
        }
        return this.expireNanos != -1L && System.nanoTime() - itemProperties.getExpireNanos() > this.expireNanos;
    }

    private CacheItemProperties cacheItemProperties() {
        CacheItemProperties cacheItemProperties = new CacheItemProperties();
        cacheItemProperties.setExpireNanos(System.nanoTime());
        return cacheItemProperties;
    }
}

