/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.mongo.v3_1;

import com.mongodb.event.CommandStartedEvent;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.mongo.v3_1.MongoAttributesExtractor;
import io.opentelemetry.instrumentation.mongo.v3_1.MongoDbAttributesGetter;

class MongoSpanNameExtractor
implements SpanNameExtractor<CommandStartedEvent> {
    private static final String DEFAULT_SPAN_NAME = "DB Query";
    private final MongoDbAttributesGetter dbAttributesGetter;
    private final MongoAttributesExtractor attributesExtractor;

    MongoSpanNameExtractor(MongoDbAttributesGetter dbAttributesGetter, MongoAttributesExtractor attributesExtractor) {
        this.dbAttributesGetter = dbAttributesGetter;
        this.attributesExtractor = attributesExtractor;
    }

    public String extract(CommandStartedEvent event) {
        String operation = this.dbAttributesGetter.getDbOperationName(event);
        String dbName = this.dbAttributesGetter.getDbNamespace(event);
        if (operation == null) {
            return dbName == null ? DEFAULT_SPAN_NAME : dbName;
        }
        String table = this.attributesExtractor.collectionName(event);
        StringBuilder name = new StringBuilder(operation);
        if (dbName != null || table != null) {
            name.append(' ');
        }
        if (dbName != null && (table == null || table.indexOf(46) == -1)) {
            name.append(dbName);
            if (table != null) {
                name.append('.');
            }
        }
        if (table != null) {
            name.append(table);
        }
        return name.toString();
    }
}

