/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.alert.notice.impl;

import org.apache.hertzbeat.alert.notice.AlertNoticeException;
import org.apache.hertzbeat.alert.notice.impl.AbstractAlertNotifyHandlerImpl;
import org.apache.hertzbeat.common.entity.alerter.GroupAlert;
import org.apache.hertzbeat.common.entity.alerter.NoticeReceiver;
import org.apache.hertzbeat.common.entity.alerter.NoticeTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;

@Component
final class WebHookAlertNotifyHandlerImpl
extends AbstractAlertNotifyHandlerImpl {
    private static final Logger log = LoggerFactory.getLogger(WebHookAlertNotifyHandlerImpl.class);

    WebHookAlertNotifyHandlerImpl() {
    }

    @Override
    public void send(NoticeReceiver receiver, NoticeTemplate noticeTemplate, GroupAlert alert) {
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            String webhookJson = this.renderContent(noticeTemplate, alert);
            webhookJson = webhookJson.replace(",\n  }", "\n }");
            HttpEntity alertHttpEntity = new HttpEntity((Object)webhookJson, (MultiValueMap)headers);
            ResponseEntity entity = this.restTemplate.postForEntity(receiver.getHookUrl(), (Object)alertHttpEntity, String.class, new Object[0]);
            if (entity.getStatusCode().value() >= HttpStatus.BAD_REQUEST.value()) {
                log.warn("Send WebHook: {} Failed: {}", (Object)receiver.getHookUrl(), entity.getBody());
                throw new AlertNoticeException("Http StatusCode " + entity.getStatusCode());
            }
            log.debug("Send WebHook: {} Success", (Object)receiver.getHookUrl());
        }
        catch (Exception e) {
            throw new AlertNoticeException("[WebHook Notify Error] " + e.getMessage());
        }
    }

    @Override
    public byte type() {
        return 2;
    }
}

