/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.s7.readwrite;

import java.math.BigInteger;
import java.time.ZoneOffset;
import java.time.temporal.ChronoField;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.s7.readwrite.ControllerType;
import org.apache.plc4x.java.s7.readwrite.utils.StaticHelper;
import org.apache.plc4x.java.spi.codegen.WithOption;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.ByteOrder;
import org.apache.plc4x.java.spi.generation.EvaluationHelper;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.values.PlcBOOL;
import org.apache.plc4x.java.spi.values.PlcBYTE;
import org.apache.plc4x.java.spi.values.PlcCHAR;
import org.apache.plc4x.java.spi.values.PlcDATE;
import org.apache.plc4x.java.spi.values.PlcDATE_AND_LTIME;
import org.apache.plc4x.java.spi.values.PlcDATE_AND_TIME;
import org.apache.plc4x.java.spi.values.PlcDINT;
import org.apache.plc4x.java.spi.values.PlcDWORD;
import org.apache.plc4x.java.spi.values.PlcINT;
import org.apache.plc4x.java.spi.values.PlcLINT;
import org.apache.plc4x.java.spi.values.PlcLREAL;
import org.apache.plc4x.java.spi.values.PlcLTIME;
import org.apache.plc4x.java.spi.values.PlcLTIME_OF_DAY;
import org.apache.plc4x.java.spi.values.PlcLWORD;
import org.apache.plc4x.java.spi.values.PlcREAL;
import org.apache.plc4x.java.spi.values.PlcSINT;
import org.apache.plc4x.java.spi.values.PlcSTRING;
import org.apache.plc4x.java.spi.values.PlcTIME;
import org.apache.plc4x.java.spi.values.PlcTIME_OF_DAY;
import org.apache.plc4x.java.spi.values.PlcUDINT;
import org.apache.plc4x.java.spi.values.PlcUINT;
import org.apache.plc4x.java.spi.values.PlcULINT;
import org.apache.plc4x.java.spi.values.PlcUSINT;
import org.apache.plc4x.java.spi.values.PlcWORD;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataItem {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataItem.class);

    public static PlcValue staticParse(ReadBuffer readBuffer, String dataProtocolId, ControllerType controllerType, Integer stringLength) throws ParseException {
        if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_BOOL")) {
            Byte reservedField0 = (Byte)FieldReaderFactory.readReservedField((String)"reserved", (DataReader)DataReaderFactory.readUnsignedByte((ReadBuffer)readBuffer, (int)7), (Object)0, (WithReaderArgs[])new WithReaderArgs[0]);
            boolean value = (Boolean)FieldReaderFactory.readSimpleField((String)"value", (DataReader)DataReaderFactory.readBoolean((ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
            return new PlcBOOL(value);
        }
        if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_BYTE")) {
            short value = (Short)FieldReaderFactory.readSimpleField((String)"value", (DataReader)DataReaderFactory.readUnsignedShort((ReadBuffer)readBuffer, (int)8), (WithReaderArgs[])new WithReaderArgs[0]);
            return new PlcBYTE(value);
        }
        if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_WORD")) {
            int value = (Integer)FieldReaderFactory.readSimpleField((String)"value", (DataReader)DataReaderFactory.readUnsignedInt((ReadBuffer)readBuffer, (int)16), (WithReaderArgs[])new WithReaderArgs[0]);
            return new PlcWORD(value);
        }
        if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_DWORD")) {
            long value = (Long)FieldReaderFactory.readSimpleField((String)"value", (DataReader)DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
            return new PlcDWORD(value);
        }
        if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_LWORD")) {
            BigInteger value = (BigInteger)FieldReaderFactory.readSimpleField((String)"value", (DataReader)DataReaderFactory.readUnsignedBigInteger((ReadBuffer)readBuffer, (int)64), (WithReaderArgs[])new WithReaderArgs[0]);
            return new PlcLWORD(value);
        }
        if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_SINT")) {
            byte value = (Byte)FieldReaderFactory.readSimpleField((String)"value", (DataReader)DataReaderFactory.readSignedByte((ReadBuffer)readBuffer, (int)8), (WithReaderArgs[])new WithReaderArgs[0]);
            return new PlcSINT(value);
        }
        if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_USINT")) {
            short value = (Short)FieldReaderFactory.readSimpleField((String)"value", (DataReader)DataReaderFactory.readUnsignedShort((ReadBuffer)readBuffer, (int)8), (WithReaderArgs[])new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_INT")) {
            short value = (Short)FieldReaderFactory.readSimpleField((String)"value", (DataReader)DataReaderFactory.readSignedShort((ReadBuffer)readBuffer, (int)16), (WithReaderArgs[])new WithReaderArgs[0]);
            return new PlcINT(value);
        }
        if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_UINT")) {
            int value = (Integer)FieldReaderFactory.readSimpleField((String)"value", (DataReader)DataReaderFactory.readUnsignedInt((ReadBuffer)readBuffer, (int)16), (WithReaderArgs[])new WithReaderArgs[0]);
            return new PlcUINT(value);
        }
        if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_DINT")) {
            int value = (Integer)FieldReaderFactory.readSimpleField((String)"value", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
            return new PlcDINT(value);
        }
        if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_UDINT")) {
            long value = (Long)FieldReaderFactory.readSimpleField((String)"value", (DataReader)DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
            return new PlcUDINT(value);
        }
        if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_LINT")) {
            long value = (Long)FieldReaderFactory.readSimpleField((String)"value", (DataReader)DataReaderFactory.readSignedLong((ReadBuffer)readBuffer, (int)64), (WithReaderArgs[])new WithReaderArgs[0]);
            return new PlcLINT(value);
        }
        if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_ULINT")) {
            BigInteger value = (BigInteger)FieldReaderFactory.readSimpleField((String)"value", (DataReader)DataReaderFactory.readUnsignedBigInteger((ReadBuffer)readBuffer, (int)64), (WithReaderArgs[])new WithReaderArgs[0]);
            return new PlcULINT(value);
        }
        if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_REAL")) {
            float value = ((Float)FieldReaderFactory.readSimpleField((String)"value", (DataReader)DataReaderFactory.readFloat((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0])).floatValue();
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_LREAL")) {
            double value = (Double)FieldReaderFactory.readSimpleField((String)"value", (DataReader)DataReaderFactory.readDouble((ReadBuffer)readBuffer, (int)64), (WithReaderArgs[])new WithReaderArgs[0]);
            return new PlcLREAL(value);
        }
        if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_CHAR")) {
            String value = (String)FieldReaderFactory.readSimpleField((String)"value", (DataReader)DataReaderFactory.readString((ReadBuffer)readBuffer, (int)8), (WithReaderArgs[])new WithReaderArgs[]{WithOption.WithEncoding((String)"UTF-8")});
            return new PlcCHAR(value);
        }
        if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_WCHAR")) {
            String value = (String)FieldReaderFactory.readSimpleField((String)"value", (DataReader)DataReaderFactory.readString((ReadBuffer)readBuffer, (int)16), (WithReaderArgs[])new WithReaderArgs[]{WithOption.WithEncoding((String)"UTF-16")});
            return new PlcCHAR(value);
        }
        if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_STRING")) {
            String value = (String)FieldReaderFactory.readManualField((String)"value", (ReadBuffer)readBuffer, () -> StaticHelper.parseS7String(readBuffer, stringLength, "UTF-8"), (WithReaderArgs[])new WithReaderArgs[]{WithOption.WithEncoding((String)"UTF-8")});
            return new PlcSTRING(value);
        }
        if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_WSTRING")) {
            String value = (String)FieldReaderFactory.readManualField((String)"value", (ReadBuffer)readBuffer, () -> StaticHelper.parseS7String(readBuffer, stringLength, "UTF-16"), (WithReaderArgs[])new WithReaderArgs[]{WithOption.WithEncoding((String)"UTF-16")});
            return new PlcSTRING(value);
        }
        if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_TIME")) {
            long milliseconds = (Long)FieldReaderFactory.readSimpleField((String)"milliseconds", (DataReader)DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
            return PlcTIME.ofMilliseconds((long)milliseconds);
        }
        if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"S7_S5TIME")) {
            long milliseconds = (Long)FieldReaderFactory.readManualField((String)"milliseconds", (ReadBuffer)readBuffer, () -> (long)StaticHelper.parseS5Time(readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
            return PlcTIME.ofMilliseconds((long)milliseconds);
        }
        if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_LTIME")) {
            BigInteger nanoseconds = (BigInteger)FieldReaderFactory.readSimpleField((String)"nanoseconds", (DataReader)DataReaderFactory.readUnsignedBigInteger((ReadBuffer)readBuffer, (int)64), (WithReaderArgs[])new WithReaderArgs[0]);
            return PlcLTIME.ofNanoseconds((BigInteger)nanoseconds);
        }
        if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_DATE")) {
            int daysSinceEpoch = (Integer)FieldReaderFactory.readManualField((String)"daysSinceEpoch", (ReadBuffer)readBuffer, () -> (int)StaticHelper.parseTiaDate(readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
            return PlcDATE.ofDaysSinceEpoch((int)daysSinceEpoch);
        }
        if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_TIME_OF_DAY")) {
            long millisecondsSinceMidnight = (Long)FieldReaderFactory.readSimpleField((String)"millisecondsSinceMidnight", (DataReader)DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
            return PlcTIME_OF_DAY.ofMillisecondsSinceMidnight((long)millisecondsSinceMidnight);
        }
        if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_LTIME_OF_DAY")) {
            BigInteger nanosecondsSinceMidnight = (BigInteger)FieldReaderFactory.readSimpleField((String)"nanosecondsSinceMidnight", (DataReader)DataReaderFactory.readUnsignedBigInteger((ReadBuffer)readBuffer, (int)64), (WithReaderArgs[])new WithReaderArgs[0]);
            return PlcLTIME_OF_DAY.ofNanosecondsSinceMidnight((BigInteger)nanosecondsSinceMidnight);
        }
        if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_DATE_AND_TIME")) {
            short year = (Short)FieldReaderFactory.readManualField((String)"year", (ReadBuffer)readBuffer, () -> StaticHelper.parseSiemensYear(readBuffer), (WithReaderArgs[])new WithReaderArgs[]{WithOption.WithEncoding((String)"BCD")});
            short month = (Short)FieldReaderFactory.readSimpleField((String)"month", (DataReader)DataReaderFactory.readUnsignedShort((ReadBuffer)readBuffer, (int)8), (WithReaderArgs[])new WithReaderArgs[]{WithOption.WithEncoding((String)"BCD")});
            short day = (Short)FieldReaderFactory.readSimpleField((String)"day", (DataReader)DataReaderFactory.readUnsignedShort((ReadBuffer)readBuffer, (int)8), (WithReaderArgs[])new WithReaderArgs[]{WithOption.WithEncoding((String)"BCD")});
            short hour = (Short)FieldReaderFactory.readSimpleField((String)"hour", (DataReader)DataReaderFactory.readUnsignedShort((ReadBuffer)readBuffer, (int)8), (WithReaderArgs[])new WithReaderArgs[]{WithOption.WithEncoding((String)"BCD")});
            short minutes = (Short)FieldReaderFactory.readSimpleField((String)"minutes", (DataReader)DataReaderFactory.readUnsignedShort((ReadBuffer)readBuffer, (int)8), (WithReaderArgs[])new WithReaderArgs[]{WithOption.WithEncoding((String)"BCD")});
            short seconds = (Short)FieldReaderFactory.readSimpleField((String)"seconds", (DataReader)DataReaderFactory.readUnsignedShort((ReadBuffer)readBuffer, (int)8), (WithReaderArgs[])new WithReaderArgs[]{WithOption.WithEncoding((String)"BCD")});
            short millisecondsOfSecond = (Short)FieldReaderFactory.readSimpleField((String)"millisecondsOfSecond", (DataReader)DataReaderFactory.readUnsignedShort((ReadBuffer)readBuffer, (int)12), (WithReaderArgs[])new WithReaderArgs[]{WithOption.WithEncoding((String)"BCD")});
            byte dayOfWeek = (Byte)FieldReaderFactory.readSimpleField((String)"dayOfWeek", (DataReader)DataReaderFactory.readUnsignedByte((ReadBuffer)readBuffer, (int)4), (WithReaderArgs[])new WithReaderArgs[]{WithOption.WithEncoding((String)"BCD")});
            return PlcDATE_AND_TIME.ofSegments((int)year, (int)(month == 0 ? (short)1 : month), (int)(day == 0 ? (short)1 : day), (int)hour, (int)minutes, (int)seconds, (int)(millisecondsOfSecond * 1000000));
        }
        if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_DATE_AND_LTIME")) {
            BigInteger nanosecondsSinceEpoch = (BigInteger)FieldReaderFactory.readSimpleField((String)"nanosecondsSinceEpoch", (DataReader)DataReaderFactory.readUnsignedBigInteger((ReadBuffer)readBuffer, (int)64), (WithReaderArgs[])new WithReaderArgs[0]);
            return PlcDATE_AND_LTIME.ofNanosecondsSinceEpoch((BigInteger)nanosecondsSinceEpoch);
        }
        if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_DTL")) {
            int year = (Integer)FieldReaderFactory.readSimpleField((String)"year", (DataReader)DataReaderFactory.readUnsignedInt((ReadBuffer)readBuffer, (int)16), (WithReaderArgs[])new WithReaderArgs[0]);
            short month = (Short)FieldReaderFactory.readSimpleField((String)"month", (DataReader)DataReaderFactory.readUnsignedShort((ReadBuffer)readBuffer, (int)8), (WithReaderArgs[])new WithReaderArgs[0]);
            short day = (Short)FieldReaderFactory.readSimpleField((String)"day", (DataReader)DataReaderFactory.readUnsignedShort((ReadBuffer)readBuffer, (int)8), (WithReaderArgs[])new WithReaderArgs[0]);
            short dayOfWeek = (Short)FieldReaderFactory.readSimpleField((String)"dayOfWeek", (DataReader)DataReaderFactory.readUnsignedShort((ReadBuffer)readBuffer, (int)8), (WithReaderArgs[])new WithReaderArgs[0]);
            short hour = (Short)FieldReaderFactory.readSimpleField((String)"hour", (DataReader)DataReaderFactory.readUnsignedShort((ReadBuffer)readBuffer, (int)8), (WithReaderArgs[])new WithReaderArgs[0]);
            short minutes = (Short)FieldReaderFactory.readSimpleField((String)"minutes", (DataReader)DataReaderFactory.readUnsignedShort((ReadBuffer)readBuffer, (int)8), (WithReaderArgs[])new WithReaderArgs[0]);
            short seconds = (Short)FieldReaderFactory.readSimpleField((String)"seconds", (DataReader)DataReaderFactory.readUnsignedShort((ReadBuffer)readBuffer, (int)8), (WithReaderArgs[])new WithReaderArgs[0]);
            long nannosecondsOfSecond = (Long)FieldReaderFactory.readSimpleField((String)"nannosecondsOfSecond", (DataReader)DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
            return PlcDATE_AND_LTIME.ofSegments((int)year, (int)(month == 0 ? (short)1 : month), (int)(day == 0 ? (short)1 : day), (int)hour, (int)minutes, (int)seconds, (long)nannosecondsOfSecond);
        }
        return null;
    }

    public static int getLengthInBytes(PlcValue _value, String dataProtocolId, ControllerType controllerType, Integer stringLength) {
        return (int)Math.ceil((double)DataItem.getLengthInBits(_value, dataProtocolId, controllerType, stringLength) / 8.0);
    }

    public static int getLengthInBits(PlcValue _value, String dataProtocolId, ControllerType controllerType, Integer stringLength) {
        int lengthInBits = 0;
        if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_BOOL")) {
            lengthInBits += 7;
            ++lengthInBits;
        } else if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_BYTE")) {
            lengthInBits += 8;
        } else if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_WORD")) {
            lengthInBits += 16;
        } else if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_DWORD")) {
            lengthInBits += 32;
        } else if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_LWORD")) {
            lengthInBits += 64;
        } else if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_SINT")) {
            lengthInBits += 8;
        } else if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_USINT")) {
            lengthInBits += 8;
        } else if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_INT")) {
            lengthInBits += 16;
        } else if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_UINT")) {
            lengthInBits += 16;
        } else if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_DINT")) {
            lengthInBits += 32;
        } else if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_UDINT")) {
            lengthInBits += 32;
        } else if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_LINT")) {
            lengthInBits += 64;
        } else if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_ULINT")) {
            lengthInBits += 64;
        } else if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_REAL")) {
            lengthInBits += 32;
        } else if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_LREAL")) {
            lengthInBits += 64;
        } else if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_CHAR")) {
            lengthInBits += 8;
        } else if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_WCHAR")) {
            lengthInBits += 16;
        } else if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_STRING")) {
            lengthInBits += stringLength * 8 + 16;
        } else if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_WSTRING")) {
            lengthInBits += stringLength * 16 + 32;
        } else if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_TIME")) {
            lengthInBits += 32;
        } else if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"S7_S5TIME")) {
            lengthInBits += 2;
        } else if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_LTIME")) {
            lengthInBits += 64;
        } else if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_DATE")) {
            lengthInBits += 16;
        } else if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_TIME_OF_DAY")) {
            lengthInBits += 32;
        } else if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_LTIME_OF_DAY")) {
            lengthInBits += 64;
        } else if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_DATE_AND_TIME")) {
            lengthInBits += 8;
            lengthInBits += 8;
            lengthInBits += 8;
            lengthInBits += 8;
            lengthInBits += 8;
            lengthInBits += 8;
            lengthInBits += 12;
            lengthInBits += 4;
        } else if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_DATE_AND_LTIME")) {
            lengthInBits += 64;
        } else if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_DTL")) {
            lengthInBits += 16;
            lengthInBits += 8;
            lengthInBits += 8;
            lengthInBits += 8;
            lengthInBits += 8;
            lengthInBits += 8;
            lengthInBits += 8;
            lengthInBits += 32;
        }
        return lengthInBits;
    }

    public static void staticSerialize(WriteBuffer writeBuffer, PlcValue _value, String dataProtocolId, ControllerType controllerType, Integer stringLength) throws SerializationException {
        DataItem.staticSerialize(writeBuffer, _value, dataProtocolId, controllerType, stringLength, ByteOrder.BIG_ENDIAN);
    }

    public static void staticSerialize(WriteBuffer writeBuffer, PlcValue _value, String dataProtocolId, ControllerType controllerType, Integer stringLength, ByteOrder byteOrder) throws SerializationException {
        if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_BOOL")) {
            FieldWriterFactory.writeReservedField((String)"reserved", (Object)0, (DataWriter)DataWriterFactory.writeUnsignedByte((WriteBuffer)writeBuffer, (int)7), (WithWriterArgs[])new WithWriterArgs[0]);
            FieldWriterFactory.writeSimpleField((String)"value", (Object)_value.getBoolean(), (DataWriter)DataWriterFactory.writeBoolean((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_BYTE")) {
            FieldWriterFactory.writeSimpleField((String)"value", (Object)_value.getShort(), (DataWriter)DataWriterFactory.writeUnsignedShort((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_WORD")) {
            FieldWriterFactory.writeSimpleField((String)"value", (Object)_value.getInteger(), (DataWriter)DataWriterFactory.writeUnsignedInt((WriteBuffer)writeBuffer, (int)16), (WithWriterArgs[])new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_DWORD")) {
            FieldWriterFactory.writeSimpleField((String)"value", (Object)_value.getLong(), (DataWriter)DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_LWORD")) {
            FieldWriterFactory.writeSimpleField((String)"value", (Object)_value.getBigInteger(), (DataWriter)DataWriterFactory.writeUnsignedBigInteger((WriteBuffer)writeBuffer, (int)64), (WithWriterArgs[])new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_SINT")) {
            FieldWriterFactory.writeSimpleField((String)"value", (Object)_value.getByte(), (DataWriter)DataWriterFactory.writeSignedByte((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_USINT")) {
            FieldWriterFactory.writeSimpleField((String)"value", (Object)_value.getShort(), (DataWriter)DataWriterFactory.writeUnsignedShort((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_INT")) {
            FieldWriterFactory.writeSimpleField((String)"value", (Object)_value.getShort(), (DataWriter)DataWriterFactory.writeSignedShort((WriteBuffer)writeBuffer, (int)16), (WithWriterArgs[])new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_UINT")) {
            FieldWriterFactory.writeSimpleField((String)"value", (Object)_value.getInteger(), (DataWriter)DataWriterFactory.writeUnsignedInt((WriteBuffer)writeBuffer, (int)16), (WithWriterArgs[])new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_DINT")) {
            FieldWriterFactory.writeSimpleField((String)"value", (Object)_value.getInteger(), (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_UDINT")) {
            FieldWriterFactory.writeSimpleField((String)"value", (Object)_value.getLong(), (DataWriter)DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_LINT")) {
            FieldWriterFactory.writeSimpleField((String)"value", (Object)_value.getLong(), (DataWriter)DataWriterFactory.writeSignedLong((WriteBuffer)writeBuffer, (int)64), (WithWriterArgs[])new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_ULINT")) {
            FieldWriterFactory.writeSimpleField((String)"value", (Object)_value.getBigInteger(), (DataWriter)DataWriterFactory.writeUnsignedBigInteger((WriteBuffer)writeBuffer, (int)64), (WithWriterArgs[])new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_REAL")) {
            FieldWriterFactory.writeSimpleField((String)"value", (Object)Float.valueOf(_value.getFloat()), (DataWriter)DataWriterFactory.writeFloat((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_LREAL")) {
            FieldWriterFactory.writeSimpleField((String)"value", (Object)_value.getDouble(), (DataWriter)DataWriterFactory.writeDouble((WriteBuffer)writeBuffer, (int)64), (WithWriterArgs[])new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_CHAR")) {
            FieldWriterFactory.writeSimpleField((String)"value", (Object)_value.getString(), (DataWriter)DataWriterFactory.writeString((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[]{WithOption.WithEncoding((String)"UTF-8")});
        } else if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_WCHAR")) {
            FieldWriterFactory.writeSimpleField((String)"value", (Object)_value.getString(), (DataWriter)DataWriterFactory.writeString((WriteBuffer)writeBuffer, (int)16), (WithWriterArgs[])new WithWriterArgs[]{WithOption.WithEncoding((String)"UTF-16")});
        } else if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_STRING")) {
            FieldWriterFactory.writeManualField((String)"value", () -> StaticHelper.serializeS7String(writeBuffer, _value, stringLength, "UTF-8"), (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[]{WithOption.WithEncoding((String)"UTF-8")});
        } else if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_WSTRING")) {
            FieldWriterFactory.writeManualField((String)"value", () -> StaticHelper.serializeS7String(writeBuffer, _value, stringLength, "UTF-16"), (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[]{WithOption.WithEncoding((String)"UTF-16")});
        } else if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_TIME")) {
            FieldWriterFactory.writeSimpleField((String)"milliseconds", (Object)_value.getDuration().toMillis(), (DataWriter)DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"S7_S5TIME")) {
            FieldWriterFactory.writeManualField((String)"milliseconds", () -> StaticHelper.serializeS5Time(writeBuffer, _value), (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_LTIME")) {
            FieldWriterFactory.writeSimpleField((String)"nanoseconds", (Object)BigInteger.valueOf(_value.getDuration().toNanos()), (DataWriter)DataWriterFactory.writeUnsignedBigInteger((WriteBuffer)writeBuffer, (int)64), (WithWriterArgs[])new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_DATE")) {
            FieldWriterFactory.writeManualField((String)"daysSinceEpoch", () -> StaticHelper.serializeTiaDate(writeBuffer, _value), (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_TIME_OF_DAY")) {
            FieldWriterFactory.writeSimpleField((String)"millisecondsSinceMidnight", (Object)_value.getTime().getLong(ChronoField.MILLI_OF_DAY), (DataWriter)DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_LTIME_OF_DAY")) {
            FieldWriterFactory.writeSimpleField((String)"nanosecondsSinceMidnight", (Object)BigInteger.valueOf(_value.getTime().getLong(ChronoField.NANO_OF_DAY)), (DataWriter)DataWriterFactory.writeUnsignedBigInteger((WriteBuffer)writeBuffer, (int)64), (WithWriterArgs[])new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_DATE_AND_TIME")) {
            FieldWriterFactory.writeManualField((String)"year", () -> StaticHelper.serializeSiemensYear(writeBuffer, _value), (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[]{WithOption.WithEncoding((String)"BCD")});
            FieldWriterFactory.writeSimpleField((String)"month", (Object)((short)_value.getDate().getMonthValue()), (DataWriter)DataWriterFactory.writeUnsignedShort((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[]{WithOption.WithEncoding((String)"BCD")});
            FieldWriterFactory.writeSimpleField((String)"day", (Object)((short)_value.getDate().getDayOfMonth()), (DataWriter)DataWriterFactory.writeUnsignedShort((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[]{WithOption.WithEncoding((String)"BCD")});
            FieldWriterFactory.writeSimpleField((String)"hour", (Object)((short)_value.getTime().getHour()), (DataWriter)DataWriterFactory.writeUnsignedShort((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[]{WithOption.WithEncoding((String)"BCD")});
            FieldWriterFactory.writeSimpleField((String)"minutes", (Object)((short)_value.getTime().getMinute()), (DataWriter)DataWriterFactory.writeUnsignedShort((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[]{WithOption.WithEncoding((String)"BCD")});
            FieldWriterFactory.writeSimpleField((String)"seconds", (Object)((short)_value.getTime().getSecond()), (DataWriter)DataWriterFactory.writeUnsignedShort((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[]{WithOption.WithEncoding((String)"BCD")});
            FieldWriterFactory.writeSimpleField((String)"millisecondsOfSecond", (Object)((short)_value.getTime().get(ChronoField.MILLI_OF_SECOND)), (DataWriter)DataWriterFactory.writeUnsignedShort((WriteBuffer)writeBuffer, (int)12), (WithWriterArgs[])new WithWriterArgs[]{WithOption.WithEncoding((String)"BCD")});
            FieldWriterFactory.writeSimpleField((String)"dayOfWeek", (Object)((byte)_value.getDate().getDayOfWeek().getValue()), (DataWriter)DataWriterFactory.writeUnsignedByte((WriteBuffer)writeBuffer, (int)4), (WithWriterArgs[])new WithWriterArgs[]{WithOption.WithEncoding((String)"BCD")});
        } else if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_DATE_AND_LTIME")) {
            FieldWriterFactory.writeSimpleField((String)"nanosecondsSinceEpoch", (Object)BigInteger.valueOf(_value.getDateTime().toEpochSecond(ZoneOffset.UTC)).multiply(BigInteger.valueOf(1000000000L)).add(BigInteger.valueOf(_value.getDateTime().getNano())), (DataWriter)DataWriterFactory.writeUnsignedBigInteger((WriteBuffer)writeBuffer, (int)64), (WithWriterArgs[])new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)dataProtocolId, (Object)"IEC61131_DTL")) {
            FieldWriterFactory.writeSimpleField((String)"year", (Object)_value.getDate().getYear(), (DataWriter)DataWriterFactory.writeUnsignedInt((WriteBuffer)writeBuffer, (int)16), (WithWriterArgs[])new WithWriterArgs[0]);
            FieldWriterFactory.writeSimpleField((String)"month", (Object)((short)_value.getDate().getMonthValue()), (DataWriter)DataWriterFactory.writeUnsignedShort((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[0]);
            FieldWriterFactory.writeSimpleField((String)"day", (Object)((short)_value.getDate().getDayOfMonth()), (DataWriter)DataWriterFactory.writeUnsignedShort((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[0]);
            FieldWriterFactory.writeSimpleField((String)"dayOfWeek", (Object)((short)_value.getDate().getDayOfWeek().getValue()), (DataWriter)DataWriterFactory.writeUnsignedShort((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[0]);
            FieldWriterFactory.writeSimpleField((String)"hour", (Object)((short)_value.getTime().getHour()), (DataWriter)DataWriterFactory.writeUnsignedShort((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[0]);
            FieldWriterFactory.writeSimpleField((String)"minutes", (Object)((short)_value.getTime().getMinute()), (DataWriter)DataWriterFactory.writeUnsignedShort((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[0]);
            FieldWriterFactory.writeSimpleField((String)"seconds", (Object)((short)_value.getTime().getSecond()), (DataWriter)DataWriterFactory.writeUnsignedShort((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[0]);
            FieldWriterFactory.writeSimpleField((String)"nannosecondsOfSecond", (Object)_value.getTime().getLong(ChronoField.NANO_OF_SECOND), (DataWriter)DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        }
    }
}

