/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.concurrency.limits.limiter;

import com.netflix.concurrency.limits.Limiter;
import com.netflix.concurrency.limits.MetricRegistry;
import com.netflix.concurrency.limits.limiter.AbstractLimiter;
import java.util.Optional;

public class SimpleLimiter<ContextT>
extends AbstractLimiter<ContextT> {
    private final MetricRegistry.SampleListener inflightDistribution;

    public static Builder newBuilder() {
        return new Builder();
    }

    public SimpleLimiter(AbstractLimiter.Builder<?> builder) {
        super(builder);
        this.inflightDistribution = builder.registry.distribution("inflight", new String[0]);
    }

    @Override
    public Optional<Limiter.Listener> acquire(ContextT context) {
        int currentInFlight = this.getInflight();
        this.inflightDistribution.addSample(currentInFlight);
        if (currentInFlight >= this.getLimit()) {
            return this.createRejectedListener();
        }
        return Optional.of(this.createListener());
    }

    public static class Builder
    extends AbstractLimiter.Builder<Builder> {
        public <ContextT> SimpleLimiter<ContextT> build() {
            return new SimpleLimiter(this);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

