/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.grafana.common;

import java.net.URL;

public interface GrafanaConstants {
    public static final String ADMIN = "admin";
    public static final String KIOSK = "?kiosk=tv";
    public static final String REFRESH = "&refresh=15s";
    public static final String INSTANCE = "&var-instance=";
    public static final String CREATE_DASHBOARD_API = "/api/dashboards/db";
    public static final String DELETE_DASHBOARD_API = "/api/dashboards/uid/%s";
    public static final String DATASOURCE_BASE_NAME = "hertzbeat";
    public static final String DATASOURCE_TYPE = "prometheus";
    public static final String DATASOURCE_ACCESS = "proxy";
    public static final String CREATE_DATASOURCE_API = "/api/datasources";
    public static final String QUERY_DATASOURCE_API = "/api/datasources/name/";
    public static final String GET_SERVICE_ACCOUNTS_API = "%s/api/serviceaccounts/search";
    public static final String ACCOUNT_NAME = "hertzbeat";
    public static final String ACCOUNT_ROLE = "Admin";
    public static final String CREATE_SERVICE_ACCOUNT_API = "%s/api/serviceaccounts";
    public static final String CREATE_SERVICE_TOKEN_API = "%s/api/serviceaccounts/%d/tokens";
    public static final String GRAFANA_CONFIG = "grafanaConfig";

    public static String generateDatasourceName(String type, String url) {
        try {
            URL parsedUrl = new URL(url);
            String host = parsedUrl.getHost();
            int port = parsedUrl.getPort();
            String hostPart = host != null ? host.replaceAll("^www\\.", "") : "localhost";
            String portPart = port > 0 && port != 80 && port != 443 ? "-" + port : "";
            return String.format("%s-%s-%s%s", "hertzbeat", type, hostPart, portPart);
        }
        catch (Exception e) {
            return String.format("%s-%s-%s", "hertzbeat", type, url.hashCode());
        }
    }

    public static String generateUseDatasource(String datasourceName) {
        return "&var-ds=" + datasourceName;
    }
}

