/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.grafana.service;

import com.fasterxml.jackson.databind.JsonNode;
import jakarta.annotation.PostConstruct;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Objects;
import org.apache.hertzbeat.common.entity.manager.GeneralConfig;
import org.apache.hertzbeat.common.util.CommonUtil;
import org.apache.hertzbeat.common.util.JsonUtil;
import org.apache.hertzbeat.grafana.config.GrafanaProperties;
import org.apache.hertzbeat.grafana.dao.GrafanaConfigDao;
import org.apache.hertzbeat.grafana.dto.GrafanaConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.support.BasicAuthenticationInterceptor;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class ServiceAccountService {
    private static final Logger log = LoggerFactory.getLogger(ServiceAccountService.class);
    private final GrafanaProperties grafanaProperties;
    private final GrafanaConfigDao grafanaConfigDao;
    private final RestTemplate restTemplate;
    private String url;
    private String username;
    private String password;
    private String prefix;

    @Autowired
    public ServiceAccountService(GrafanaProperties grafanaProperties, GrafanaConfigDao grafanaConfigDao, RestTemplate restTemplate) {
        this.grafanaProperties = grafanaProperties;
        this.grafanaConfigDao = grafanaConfigDao;
        this.restTemplate = restTemplate;
    }

    @PostConstruct
    public void init() {
        this.url = this.grafanaProperties.getUrl();
        this.username = this.grafanaProperties.username();
        this.password = this.grafanaProperties.password();
        this.prefix = this.grafanaProperties.getPrefix();
    }

    public Long createServiceAccount() {
        JsonNode accounts = Objects.requireNonNull(JsonUtil.fromJson((String)((String)this.getAccounts().getBody()))).path("serviceAccounts");
        for (JsonNode account : accounts) {
            if (!account.get("name").asText().equals("hertzbeat")) continue;
            return account.get("id").asLong();
        }
        String endpoint = String.format(this.prefix + "%s/api/serviceaccounts", this.url);
        HttpHeaders headers = this.createHeaders();
        String body = String.format("{\"name\":\"%s\",\"role\":\"%s\",\"isDisabled\":false}", "hertzbeat", "Admin");
        this.restTemplate.getInterceptors().add(new BasicAuthenticationInterceptor(this.username, this.password));
        HttpEntity request = new HttpEntity((Object)body, (MultiValueMap)headers);
        try {
            JsonNode jsonNode;
            ResponseEntity response = this.restTemplate.postForEntity(endpoint, (Object)request, String.class, new Object[0]);
            if (response.getStatusCode().is2xxSuccessful() && (jsonNode = JsonUtil.fromJson((String)((String)response.getBody()))) != null && jsonNode.has("id")) {
                return jsonNode.get("id").asLong();
            }
        }
        catch (Exception e) {
            log.error("Service account creation failed", (Throwable)e);
            throw new RuntimeException("Service account creation failed");
        }
        return null;
    }

    public String applyForToken() {
        Long accountId = this.createServiceAccount();
        if (accountId == null) {
            log.error("Service account not found");
            throw new RuntimeException("Service account not found");
        }
        String endpoint = String.format(this.prefix + "%s/api/serviceaccounts/%d/tokens", this.url, accountId);
        HttpHeaders headers = this.createHeaders();
        String body = String.format("{\"name\":\"%s\"}", CommonUtil.generateRandomWord((int)6));
        this.restTemplate.getInterceptors().add(new BasicAuthenticationInterceptor(this.username, this.password));
        HttpEntity request = new HttpEntity((Object)body, (MultiValueMap)headers);
        try {
            ResponseEntity response = this.restTemplate.postForEntity(endpoint, (Object)request, String.class, new Object[0]);
            if (response.getStatusCode().is2xxSuccessful()) {
                JsonNode jsonNode = JsonUtil.fromJson((String)((String)response.getBody()));
                if (jsonNode != null && jsonNode.has("key")) {
                    String token = jsonNode.get("key").asText();
                    GrafanaConfig grafanaConfig = GrafanaConfig.builder().token(token).build();
                    GeneralConfig generalConfig = GeneralConfig.builder().type("grafanaConfig").content(JsonUtil.toJson((Object)grafanaConfig)).build();
                    this.grafanaConfigDao.save(generalConfig);
                    return token;
                }
                log.info("Create token success: {}", response.getBody());
            }
        }
        catch (Exception e) {
            log.error("Create token error", (Throwable)e);
            throw new RuntimeException("Create token error");
        }
        return null;
    }

    public String getToken() {
        GeneralConfig generalConfig = this.grafanaConfigDao.findByType("grafanaConfig");
        if (generalConfig == null) {
            log.error("Service token not found");
            return null;
        }
        GrafanaConfig grafanaConfig = (GrafanaConfig)JsonUtil.fromJson((String)generalConfig.getContent(), GrafanaConfig.class);
        if (grafanaConfig == null) {
            log.error("Service token not found");
            return null;
        }
        return grafanaConfig.getToken();
    }

    public ResponseEntity<String> getAccounts() {
        String endpoint = String.format(this.prefix + "%s/api/serviceaccounts/search", this.url);
        HttpHeaders headers = this.createHeaders();
        this.restTemplate.getInterceptors().add(new BasicAuthenticationInterceptor(this.username, this.password));
        HttpEntity request = new HttpEntity((MultiValueMap)headers);
        try {
            ResponseEntity response = this.restTemplate.exchange(endpoint, HttpMethod.GET, request, String.class, new Object[0]);
            if (response.getStatusCode().is2xxSuccessful()) {
                log.info("Get accounts success");
            }
            return response;
        }
        catch (Exception e) {
            log.error("Get accounts error", (Throwable)e);
            throw new RuntimeException("Get accounts error");
        }
    }

    private HttpHeaders createHeaders() {
        String auth = this.username + ":" + this.password;
        String encodedAuth = Base64.getEncoder().encodeToString(auth.getBytes(StandardCharsets.UTF_8));
        String authHeader = "Basic " + encodedAuth;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("Authorization", authHeader);
        return headers;
    }
}

