/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.extension.incubator.resources;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.autoconfigure.spi.internal.ConditionalResourceProvider;
import io.opentelemetry.sdk.resources.Resource;
import java.util.UUID;

public final class ServiceInstanceIdResourceProvider
implements ConditionalResourceProvider {
    public static final AttributeKey<String> SERVICE_INSTANCE_ID = AttributeKey.stringKey((String)"service.instance.id");
    private static final Resource RANDOM = Resource.create((Attributes)Attributes.of(SERVICE_INSTANCE_ID, (Object)UUID.randomUUID().toString()));
    static final int ORDER = Integer.MAX_VALUE;

    public Resource createResource(ConfigProperties config) {
        return RANDOM;
    }

    public boolean shouldApply(ConfigProperties config, Resource existing) {
        return existing.getAttribute(SERVICE_INSTANCE_ID) == null;
    }

    public int order() {
        return Integer.MAX_VALUE;
    }
}

