/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.info;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;

public class ProcessInfo {
    private static final Runtime runtime = Runtime.getRuntime();
    private final long pid;
    private final long parentPid;
    private final String owner;

    public ProcessInfo() {
        ProcessHandle process = ProcessHandle.current();
        this.pid = process.pid();
        this.parentPid = process.parent().map(ProcessHandle::pid).orElse(-1L);
        this.owner = process.info().user().orElse(null);
    }

    public int getCpus() {
        return runtime.availableProcessors();
    }

    public MemoryInfo getMemory() {
        return new MemoryInfo();
    }

    public long getPid() {
        return this.pid;
    }

    public long getParentPid() {
        return this.parentPid;
    }

    public String getOwner() {
        return this.owner;
    }

    public static class MemoryInfo {
        private static final MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
        private final MemoryUsageInfo heap = new MemoryUsageInfo(memoryMXBean.getHeapMemoryUsage());
        private final MemoryUsageInfo nonHeap = new MemoryUsageInfo(memoryMXBean.getNonHeapMemoryUsage());

        MemoryInfo() {
        }

        public MemoryUsageInfo getHeap() {
            return this.heap;
        }

        public MemoryUsageInfo getNonHeap() {
            return this.nonHeap;
        }

        public static class MemoryUsageInfo {
            private final MemoryUsage memoryUsage;

            MemoryUsageInfo(MemoryUsage memoryUsage) {
                this.memoryUsage = memoryUsage;
            }

            public long getInit() {
                return this.memoryUsage.getInit();
            }

            public long getUsed() {
                return this.memoryUsage.getUsed();
            }

            public long getCommitted() {
                return this.memoryUsage.getCommitted();
            }

            public long getMax() {
                return this.memoryUsage.getMax();
            }
        }
    }
}

