/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet.namednumber;

import java.util.HashMap;
import java.util.Map;
import org.pcap4j.packet.namednumber.NamedNumber;

public final class IpV4TosTos
extends NamedNumber<Byte, IpV4TosTos> {
    private static final long serialVersionUID = -7507790549660176346L;
    public static final IpV4TosTos DEFAULT = new IpV4TosTos((byte)0, "Default");
    public static final IpV4TosTos MINIMIZE_MONETARY_COST = new IpV4TosTos((byte)1, "Minimize Monetary Cost");
    public static final IpV4TosTos MAXIMIZE_RELIABILITY = new IpV4TosTos((byte)2, "Maximize Reliability");
    public static final IpV4TosTos MAXIMIZE_THROUGHPUT = new IpV4TosTos((byte)4, "Maximize Throughput");
    public static final IpV4TosTos MINIMIZE_DELAY = new IpV4TosTos((byte)8, "Minimize Delay");
    public static final IpV4TosTos MAXIMIZE_SECURITY = new IpV4TosTos((byte)15, "Maximize Security");
    private static final Map<Byte, IpV4TosTos> registry = new HashMap<Byte, IpV4TosTos>();

    public IpV4TosTos(Byte value, String name) {
        super(value, name);
        if ((value & 0xF0) != 0) {
            throw new IllegalArgumentException(value + " is invalid value. TOS field of IPv4 TOS must be between 0 and 15");
        }
    }

    public static IpV4TosTos getInstance(Byte value) {
        if (registry.containsKey(value)) {
            return registry.get(value);
        }
        return new IpV4TosTos(value, "unknown");
    }

    public static IpV4TosTos register(IpV4TosTos tos) {
        return registry.put((Byte)tos.value(), tos);
    }

    @Override
    public int compareTo(IpV4TosTos o) {
        return ((Byte)this.value()).compareTo((Byte)o.value());
    }

    static {
        registry.put((Byte)DEFAULT.value(), DEFAULT);
        registry.put((Byte)MINIMIZE_MONETARY_COST.value(), MINIMIZE_MONETARY_COST);
        registry.put((Byte)MAXIMIZE_RELIABILITY.value(), MAXIMIZE_RELIABILITY);
        registry.put((Byte)MAXIMIZE_THROUGHPUT.value(), MAXIMIZE_THROUGHPUT);
        registry.put((Byte)MINIMIZE_DELAY.value(), MINIMIZE_DELAY);
        registry.put((Byte)MAXIMIZE_SECURITY.value(), MAXIMIZE_SECURITY);
    }
}

