/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.tools.command.message;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.rocketmq.client.QueryResult;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.trace.TraceType;
import org.apache.rocketmq.client.trace.TraceView;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.remoting.RPCHook;
import org.apache.rocketmq.tools.admin.DefaultMQAdminExt;
import org.apache.rocketmq.tools.command.SubCommand;
import org.apache.rocketmq.tools.command.SubCommandException;

public class QueryMsgTraceByIdSubCommand
implements SubCommand {
    @Override
    public Options buildCommandlineOptions(Options options) {
        Option opt = new Option("i", "msgId", true, "Message Id");
        opt.setRequired(true);
        options.addOption(opt);
        opt = new Option("t", "traceTopic", true, "The name value of message trace topic");
        opt.setRequired(false);
        options.addOption(opt);
        return options;
    }

    @Override
    public String commandDesc() {
        return "query a message trace";
    }

    @Override
    public String commandName() {
        return "queryMsgTraceById";
    }

    @Override
    public String commandAlias() {
        return "QueryMsgTraceById";
    }

    @Override
    public void execute(CommandLine commandLine, Options options, RPCHook rpcHook) throws SubCommandException {
        DefaultMQAdminExt defaultMQAdminExt = new DefaultMQAdminExt(rpcHook);
        defaultMQAdminExt.setInstanceName(Long.toString(System.currentTimeMillis()));
        try {
            String msgId = commandLine.getOptionValue('i').trim();
            String traceTopic = "RMQ_SYS_TRACE_TOPIC";
            if (commandLine.hasOption('t')) {
                traceTopic = commandLine.getOptionValue('t').trim();
            }
            this.queryTraceByMsgId(defaultMQAdminExt, traceTopic, msgId);
        }
        catch (Exception e) {
            throw new SubCommandException(this.getClass().getSimpleName() + "command failed", e);
        }
        finally {
            defaultMQAdminExt.shutdown();
        }
    }

    private void queryTraceByMsgId(DefaultMQAdminExt admin, String traceTopic, String msgId) throws MQClientException, InterruptedException {
        admin.start();
        QueryResult queryResult = admin.queryMessage(traceTopic, msgId, 64, 0L, System.currentTimeMillis());
        List messageList = queryResult.getMessageList();
        ArrayList<TraceView> traceViews = new ArrayList<TraceView>();
        for (MessageExt message : messageList) {
            List traceView = TraceView.decodeFromTraceTransData((String)msgId, (MessageExt)message);
            traceViews.addAll(traceView);
        }
        this.printMessageTrace(traceViews);
    }

    private void printMessageTrace(List<TraceView> traceViews) {
        HashMap consumerTraceMap = new HashMap(16);
        for (TraceView traceView : traceViews) {
            if (traceView.getMsgType().equals(TraceType.Pub.name())) {
                System.out.printf("%-10s %-20s %-20s %-20s %-10s %-10s%n", "#Type", "#ProducerGroup", "#ClientHost", "#SendTime", "#CostTimes", "#Status");
                System.out.printf("%-10s %-20s %-20s %-20s %-10s %-10s%n", "Pub", traceView.getGroupName(), traceView.getClientHost(), DateFormatUtils.format((long)traceView.getTimeStamp(), (String)"yyyy-MM-dd HH:mm:ss"), traceView.getCostTime() + "ms", traceView.getStatus());
                System.out.printf("\n", new Object[0]);
            }
            if (!traceView.getMsgType().equals(TraceType.SubAfter.name())) continue;
            String groupName = traceView.getGroupName();
            if (consumerTraceMap.containsKey(groupName)) {
                ((List)consumerTraceMap.get(groupName)).add(traceView);
                continue;
            }
            ArrayList<TraceView> views = new ArrayList<TraceView>();
            views.add(traceView);
            consumerTraceMap.put(groupName, views);
        }
        Iterator consumers = consumerTraceMap.keySet().iterator();
        while (consumers.hasNext()) {
            System.out.printf("%-10s %-20s %-20s %-20s %-10s %-10s%n", "#Type", "#ConsumerGroup", "#ClientHost", "#ConsumerTime", "#CostTimes", "#Status");
            List consumerTraces = (List)consumerTraceMap.get(consumers.next());
            for (TraceView traceView : consumerTraces) {
                System.out.printf("%-10s %-20s %-20s %-20s %-10s %-10s%n", "Sub", traceView.getGroupName(), traceView.getClientHost(), DateFormatUtils.format((long)traceView.getTimeStamp(), (String)"yyyy-MM-dd HH:mm:ss"), traceView.getCostTime() + "ms", traceView.getStatus());
            }
            System.out.printf("\n", new Object[0]);
        }
    }
}

