/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.common.utils;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;

public class StringUtils {
    public static final String EMPTY = "";
    public static final String CONTEXT_SEP = "/";
    public static final String ALL = "*";
    public static final String DEFAULT = "default";
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    public static final String NULL = "null";
    public static final String[] EMPTY_STRING_ARRAY = new String[0];

    public static boolean isEmpty(CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    public static boolean isNotEmpty(CharSequence cs) {
        return !StringUtils.isEmpty(cs);
    }

    public static boolean isBlank(CharSequence cs) {
        int strLen;
        if (cs == null || (strLen = cs.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(CharSequence cs) {
        return !StringUtils.isBlank(cs);
    }

    public static String trim(String str) {
        return str == null ? null : str.trim();
    }

    public static String trimToNull(String str) {
        String ts = StringUtils.trim(str);
        return StringUtils.isEmpty(ts) ? null : ts;
    }

    public static String trimToEmpty(String str) {
        return str == null ? EMPTY : str.trim();
    }

    public static String toString(byte[] bytes, String charsetName) throws UnsupportedEncodingException {
        return charsetName == null ? new String(bytes) : new String(bytes, charsetName);
    }

    public static String defaultString(Object str) {
        return StringUtils.toString(str, EMPTY);
    }

    public static String toString(Object o, String defaultVal) {
        return o == null ? defaultVal : o.toString();
    }

    public static String toString(Object o) {
        return StringUtils.toString(o, null);
    }

    public static String objectsToString(Object[] args) {
        if (args == null) {
            return null;
        }
        if (args.length == 0) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder().append("[");
        for (Object arg : args) {
            sb.append(arg.toString()).append(",");
        }
        sb.setCharAt(sb.length() - 1, ']');
        return sb.toString();
    }

    public static boolean equals(CharSequence s1, CharSequence s2) {
        return s1 == null ? s2 == null : s1.equals(s2);
    }

    public static String[] split(String src, String separator) {
        if (StringUtils.isEmpty(separator)) {
            return new String[]{src};
        }
        if (StringUtils.isEmpty(src)) {
            return EMPTY_STRING_ARRAY;
        }
        return src.split(separator, -1);
    }

    public static String[] splitWithCommaOrSemicolon(String src) {
        if (StringUtils.isEmpty(src)) {
            return EMPTY_STRING_ARRAY;
        }
        String[] ss = StringUtils.split(src.replace(',', ';'), ";");
        ArrayList<String> list = new ArrayList<String>();
        for (String s : ss) {
            if (StringUtils.isBlank(s)) continue;
            list.add(s.trim());
        }
        return list.toArray(new String[list.size()]);
    }

    public static String join(String[] strings, String separator) {
        if (strings == null || strings.length == 0) {
            return EMPTY;
        }
        StringBuilder sb = new StringBuilder();
        for (String string : strings) {
            if (!StringUtils.isNotBlank(string)) continue;
            sb.append(string).append(separator);
        }
        return sb.length() > 0 ? sb.substring(0, sb.length() - separator.length()) : EMPTY;
    }

    public static String joinWithComma(String ... strings) {
        return StringUtils.join(strings, ",");
    }

    public static String substringAfter(String str, String separator) {
        if (str == null || str.length() == 0) {
            return str;
        }
        if (separator == null) {
            return EMPTY;
        }
        int pos = str.indexOf(separator);
        if (pos < 0) {
            return EMPTY;
        }
        return str.substring(pos + separator.length());
    }

    public static String substringBefore(String str, String separator) {
        if (StringUtils.isEmpty(str) || separator == null) {
            return str;
        }
        if (separator.length() == 0) {
            return EMPTY;
        }
        int pos = str.indexOf(separator);
        if (pos == -1) {
            return str;
        }
        return str.substring(0, pos);
    }
}

