/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.aggregator;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hugegraph.computer.core.aggregator.Aggregator;
import org.apache.hugegraph.computer.core.common.ComputerContext;
import org.apache.hugegraph.computer.core.graph.value.Value;
import org.apache.hugegraph.util.E;

public class RegisterAggregators {
    private final Map<String, Aggregator<? extends Value>> aggregators = new ConcurrentHashMap<String, Aggregator<? extends Value>>();

    public void put(String name, Aggregator<? extends Value> aggregator) {
        E.checkArgument((name != null ? 1 : 0) != 0, (String)"The registered aggregator name can't be null", (Object[])new Object[0]);
        E.checkArgument((!name.isEmpty() ? 1 : 0) != 0, (String)"The registered aggregator name can't be empty", (Object[])new Object[0]);
        E.checkArgument((aggregator != null ? 1 : 0) != 0, (String)"The registered aggregator can't be null", (Object[])new Object[0]);
        this.aggregators.put(name, aggregator);
    }

    public Aggregator<? extends Value> copy(String name) {
        Aggregator<? extends Value> aggregator = this.aggregators.get(name);
        E.checkArgument((aggregator != null ? 1 : 0) != 0, (String)"Can't get unregistered aggregator with name '%s'", (Object[])new Object[]{name});
        return aggregator.copy();
    }

    public Map<String, Aggregator<? extends Value>> copyAll() {
        ConcurrentHashMap<String, Aggregator<? extends Value>> copy = new ConcurrentHashMap<String, Aggregator<? extends Value>>();
        for (Map.Entry<String, Aggregator<? extends Value>> aggr : this.aggregators.entrySet()) {
            copy.put(aggr.getKey(), (Aggregator<? extends Value>)aggr.getValue().copy());
        }
        return copy;
    }

    public void clear() {
        this.aggregators.clear();
    }

    public void repair(ComputerContext context) {
        for (Aggregator<? extends Value> aggr : this.aggregators.values()) {
            aggr.repair(context);
        }
    }
}

