/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.input.loader;

import org.apache.hugegraph.computer.core.config.Config;
import org.apache.hugegraph.computer.core.input.EdgeFetcher;
import org.apache.hugegraph.computer.core.input.GraphFetcher;
import org.apache.hugegraph.computer.core.input.InputSplit;
import org.apache.hugegraph.computer.core.input.VertexFetcher;
import org.apache.hugegraph.computer.core.input.loader.FileEdgeFetcher;
import org.apache.hugegraph.computer.core.input.loader.FileVertxFetcher;
import org.apache.hugegraph.computer.core.rpc.InputSplitRpcService;

public class LoaderGraphFetcher
implements GraphFetcher {
    private final InputSplitRpcService rpcService;
    private final VertexFetcher vertexFetcher;
    private final EdgeFetcher edgeFetcher;

    public LoaderGraphFetcher(Config config, InputSplitRpcService rpcService) {
        this.vertexFetcher = new FileVertxFetcher(config);
        this.edgeFetcher = new FileEdgeFetcher(config);
        this.rpcService = rpcService;
    }

    @Override
    public InputSplit nextVertexInputSplit() {
        return this.rpcService.nextVertexInputSplit();
    }

    @Override
    public InputSplit nextEdgeInputSplit() {
        return this.rpcService.nextEdgeInputSplit();
    }

    @Override
    public VertexFetcher vertexFetcher() {
        return this.vertexFetcher;
    }

    @Override
    public EdgeFetcher edgeFetcher() {
        return this.edgeFetcher;
    }

    @Override
    public void close() {
        this.vertexFetcher.close();
        this.edgeFetcher.close();
    }
}

