/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.io;

import java.io.IOException;
import java.io.UTFDataFormatException;
import java.lang.reflect.Field;
import java.util.Arrays;
import org.apache.hugegraph.computer.core.common.exception.ComputerException;
import org.apache.hugegraph.computer.core.io.BytesOutput;
import org.apache.hugegraph.computer.core.io.RandomAccessInput;
import org.apache.hugegraph.computer.core.io.UnsafeBytesInput;
import org.apache.hugegraph.computer.core.util.CoderUtil;
import org.apache.hugegraph.util.E;
import sun.misc.Unsafe;

public class UnsafeBytesOutput
implements BytesOutput {
    private static final Unsafe UNSAFE;
    private byte[] buffer;
    private int position;

    public UnsafeBytesOutput(int size) {
        this.buffer = new byte[size];
        this.position = 0;
    }

    public void write(int b) throws IOException {
        this.require(1);
        this.buffer[this.position] = (byte)b;
        ++this.position;
    }

    public void write(byte[] b) throws IOException {
        this.require(b.length);
        System.arraycopy(b, 0, this.buffer, this.position, b.length);
        this.position += b.length;
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.require(len);
        System.arraycopy(b, off, this.buffer, this.position, len);
        this.position += len;
    }

    public void writeBoolean(boolean v) throws IOException {
        this.require(1);
        UNSAFE.putBoolean(this.buffer, this.offset(), v);
        ++this.position;
    }

    public void writeByte(int v) throws IOException {
        this.require(1);
        this.buffer[this.position] = (byte)v;
        ++this.position;
    }

    public void writeShort(int v) throws IOException {
        this.require(2);
        UNSAFE.putShort(this.buffer, this.offset(), (short)v);
        this.position += 2;
    }

    public void writeChar(int v) throws IOException {
        this.require(2);
        UNSAFE.putChar(this.buffer, this.offset(), (char)v);
        this.position += 2;
    }

    public void writeInt(int v) throws IOException {
        this.require(4);
        UNSAFE.putInt(this.buffer, this.offset(), v);
        this.position += 4;
    }

    public void writeLong(long v) throws IOException {
        this.require(8);
        UNSAFE.putLong(this.buffer, this.offset(), v);
        this.position += 8;
    }

    public void writeFloat(float v) throws IOException {
        this.require(4);
        UNSAFE.putFloat(this.buffer, this.offset(), v);
        this.position += 4;
    }

    public void writeDouble(double v) throws IOException {
        this.require(8);
        UNSAFE.putDouble(this.buffer, this.offset(), v);
        this.position += 8;
    }

    public void writeBytes(String s) throws IOException {
        int len = s.length();
        this.require(len);
        for (int i = 0; i < len; ++i) {
            this.buffer[this.position] = (byte)s.charAt(i);
            ++this.position;
        }
    }

    public void writeChars(String s) throws IOException {
        int len = s.length();
        this.require(len * 2);
        for (int i = 0; i < len; ++i) {
            char v = s.charAt(i);
            UNSAFE.putChar(this.buffer, this.offset(), v);
            this.position += 2;
        }
    }

    public void writeUTF(String s) throws IOException {
        byte[] bytes = CoderUtil.encode((String)s);
        if (bytes.length > 65535) {
            throw new UTFDataFormatException("Encoded string too long: " + bytes.length + " bytes");
        }
        this.writeShort(bytes.length);
        this.write(bytes);
    }

    public long position() {
        return this.position;
    }

    public void seek(long position) throws IOException {
        this.position = (int)position;
    }

    public long skip(long bytesToSkip) throws IOException {
        E.checkArgument((bytesToSkip >= 0L ? 1 : 0) != 0, (String)"The parameter bytesToSkip must be >= 0, but got %s", (Object[])new Object[]{bytesToSkip});
        this.require((int)bytesToSkip);
        long positionBeforeSkip = this.position;
        this.position = (int)((long)this.position + bytesToSkip);
        return positionBeforeSkip;
    }

    public void write(RandomAccessInput input, long offset, long length) throws IOException {
        if (UnsafeBytesInput.class == input.getClass()) {
            byte[] buffer = ((UnsafeBytesInput)input).buffer();
            this.write(buffer, (int)offset, (int)length);
        } else {
            input.seek(offset);
            byte[] bytes = input.readBytes((int)length);
            this.write(bytes);
        }
    }

    public void writeFixedInt(int v) throws IOException {
        this.require(4);
        UNSAFE.putInt(this.buffer, this.offset(), v);
        this.position += 4;
    }

    public void writeFixedInt(long position, int v) throws IOException {
        this.require(position, 4);
        UNSAFE.putInt(this.buffer, this.offset(position), v);
    }

    public byte[] buffer() {
        return this.buffer;
    }

    public byte[] toByteArray() {
        return Arrays.copyOf(this.buffer, this.position);
    }

    protected void require(int size) throws IOException {
        if (this.position + size > this.buffer.length) {
            byte[] newBuf = new byte[this.buffer.length + size << 1];
            System.arraycopy(this.buffer, 0, newBuf, 0, this.position);
            this.buffer = newBuf;
        }
    }

    protected void require(long position, int size) throws IOException {
        if (position + (long)size > (long)this.buffer.length) {
            throw new ComputerException("Unable to write %s bytes at position %s", new Object[]{size, position});
        }
    }

    private long offset() {
        return Unsafe.ARRAY_BYTE_BASE_OFFSET + this.position;
    }

    private long offset(long position) {
        return (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + position;
    }

    public void close() throws IOException {
    }

    static {
        try {
            Field field = Unsafe.class.getDeclaredField("theUnsafe");
            field.setAccessible(true);
            UNSAFE = (Unsafe)field.get(null);
        }
        catch (Exception e) {
            throw new ComputerException("Failed to get unsafe", (Throwable)e);
        }
    }
}

