/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.master;

import java.io.Closeable;
import java.net.InetSocketAddress;
import java.util.List;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.hugegraph.computer.core.aggregator.Aggregator;
import org.apache.hugegraph.computer.core.aggregator.DefaultAggregator;
import org.apache.hugegraph.computer.core.aggregator.MasterAggrManager;
import org.apache.hugegraph.computer.core.bsp.Bsp4Master;
import org.apache.hugegraph.computer.core.combiner.Combiner;
import org.apache.hugegraph.computer.core.common.ComputerContext;
import org.apache.hugegraph.computer.core.common.ContainerInfo;
import org.apache.hugegraph.computer.core.common.exception.ComputerException;
import org.apache.hugegraph.computer.core.config.ComputerOptions;
import org.apache.hugegraph.computer.core.config.Config;
import org.apache.hugegraph.computer.core.graph.SuperstepStat;
import org.apache.hugegraph.computer.core.graph.value.Value;
import org.apache.hugegraph.computer.core.graph.value.ValueType;
import org.apache.hugegraph.computer.core.input.MasterInputManager;
import org.apache.hugegraph.computer.core.manager.Managers;
import org.apache.hugegraph.computer.core.master.MasterComputation;
import org.apache.hugegraph.computer.core.master.MasterComputationContext;
import org.apache.hugegraph.computer.core.master.MasterContext;
import org.apache.hugegraph.computer.core.network.TransportUtil;
import org.apache.hugegraph.computer.core.output.ComputerOutput;
import org.apache.hugegraph.computer.core.rpc.MasterRpcManager;
import org.apache.hugegraph.computer.core.util.ShutdownHook;
import org.apache.hugegraph.computer.core.worker.WorkerStat;
import org.apache.hugegraph.config.TypedOption;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.Log;
import org.apache.hugegraph.util.TimeUtil;
import org.slf4j.Logger;

public class MasterService
implements Closeable {
    private static final Logger LOG = Log.logger(MasterService.class);
    private final ComputerContext context = ComputerContext.instance();
    private final Managers managers = new Managers();
    private volatile boolean inited;
    private volatile boolean closed = false;
    private Config config;
    private volatile Bsp4Master bsp4Master;
    private ContainerInfo masterInfo;
    private List<ContainerInfo> workers;
    private int maxSuperStep;
    private MasterComputation masterComputation;
    private volatile ShutdownHook shutdownHook = new ShutdownHook();
    private volatile Thread serviceThread;

    public void init(Config config) {
        E.checkArgument((!this.inited ? 1 : 0) != 0, (String)"The %s has been initialized", (Object[])new Object[]{this});
        LOG.info("{} Start to initialize master", (Object)this);
        this.serviceThread = Thread.currentThread();
        this.registerShutdownHook();
        this.config = config;
        this.maxSuperStep = (Integer)this.config.get((TypedOption)ComputerOptions.BSP_MAX_SUPER_STEP);
        InetSocketAddress rpcAddress = this.initManagers();
        this.masterInfo = new ContainerInfo(0, TransportUtil.host(rpcAddress), rpcAddress.getPort());
        this.bsp4Master = new Bsp4Master(this.config);
        this.bsp4Master.clean();
        this.masterComputation = (MasterComputation)this.config.createObject(ComputerOptions.MASTER_COMPUTATION_CLASS);
        this.masterComputation.init((MasterContext)new DefaultMasterContext());
        this.managers.initedAll(config);
        LOG.info("{} register MasterService", (Object)this);
        this.bsp4Master.masterInitDone(this.masterInfo);
        this.workers = this.bsp4Master.waitWorkersInitDone();
        LOG.info("{} waited all workers registered, workers count: {}", (Object)this, (Object)this.workers.size());
        LOG.info("{} MasterService initialized", (Object)this);
        this.inited = true;
    }

    private void stopServiceThread() {
        if (this.serviceThread == null) {
            return;
        }
        try {
            this.serviceThread.interrupt();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void registerShutdownHook() {
        this.shutdownHook.hook(() -> {
            this.stopServiceThread();
            this.cleanAndCloseBsp();
        });
    }

    @Override
    public synchronized void close() {
        this.checkInited();
        if (this.closed) {
            LOG.info("{} MasterService had closed before", (Object)this);
            return;
        }
        this.masterComputation.close((MasterContext)new DefaultMasterContext());
        this.bsp4Master.waitWorkersCloseDone();
        this.managers.closeAll(this.config);
        this.cleanAndCloseBsp();
        this.shutdownHook.unhook();
        this.closed = true;
        LOG.info("{} MasterService closed", (Object)this);
    }

    private void cleanAndCloseBsp() {
        if (this.bsp4Master == null) {
            return;
        }
        this.bsp4Master.clean();
        this.bsp4Master.close();
    }

    public void execute() {
        SuperstepStat superstepStat;
        StopWatch watcher = new StopWatch();
        this.checkInited();
        LOG.info("{} MasterService execute", (Object)this);
        int superstep = this.superstepToResume();
        LOG.info("{} MasterService resume from superstep: {}", (Object)this, (Object)superstep);
        this.bsp4Master.masterResumeDone(superstep);
        watcher.start();
        if (superstep == -1) {
            superstepStat = this.inputstep();
            ++superstep;
        } else {
            superstepStat = null;
        }
        watcher.stop();
        LOG.info("{} MasterService input step cost: {}", (Object)this, (Object)TimeUtil.readableTime((long)watcher.getTime()));
        E.checkState((superstep <= this.maxSuperStep ? 1 : 0) != 0, (String)"The superstep {} can't be > maxSuperStep {}", (Object[])new Object[]{superstep, this.maxSuperStep});
        watcher.reset();
        watcher.start();
        while (superstepStat.active()) {
            LOG.info("{} MasterService superstep {} started", (Object)this, (Object)superstep);
            this.bsp4Master.waitWorkersStepPrepareDone(superstep);
            this.managers.beforeSuperstep(this.config, superstep);
            this.bsp4Master.masterStepPrepareDone(superstep);
            this.bsp4Master.waitWorkersStepComputeDone(superstep);
            this.bsp4Master.masterStepComputeDone(superstep);
            List<WorkerStat> workerStats = this.bsp4Master.waitWorkersStepDone(superstep);
            superstepStat = SuperstepStat.from(workerStats);
            SuperstepContext context = new SuperstepContext(superstep, superstepStat);
            boolean masterContinue = this.masterComputation.compute((MasterComputationContext)context);
            if (this.finishedIteration(masterContinue, context)) {
                superstepStat.inactivate();
            }
            this.managers.afterSuperstep(this.config, superstep);
            this.bsp4Master.masterStepDone(superstep, superstepStat);
            LOG.info("{} MasterService superstep {} finished", (Object)this, (Object)superstep);
            ++superstep;
        }
        watcher.stop();
        LOG.info("{} MasterService compute step cost: {}", (Object)this, (Object)TimeUtil.readableTime((long)watcher.getTime()));
        watcher.reset();
        watcher.start();
        this.outputstep();
        watcher.stop();
        LOG.info("{} MasterService output step cost: {}", (Object)this, (Object)TimeUtil.readableTime((long)watcher.getTime()));
    }

    public String toString() {
        Object id = this.masterInfo == null ? "?" + this.hashCode() : Integer.valueOf(this.masterInfo.id());
        return String.format("[master %s]", id);
    }

    private InetSocketAddress initManagers() {
        MasterInputManager inputManager = new MasterInputManager();
        this.managers.add(inputManager);
        MasterAggrManager aggregatorManager = new MasterAggrManager();
        this.managers.add(aggregatorManager);
        MasterRpcManager rpcManager = new MasterRpcManager();
        this.managers.add(rpcManager);
        this.managers.initAll(this.config);
        rpcManager.registerInputSplitService(inputManager.handler());
        rpcManager.registerAggregatorService(aggregatorManager.handler());
        InetSocketAddress address = rpcManager.start();
        LOG.info("{} MasterService started rpc server: {}", (Object)this, (Object)address);
        return address;
    }

    private void checkInited() {
        E.checkArgument((boolean)this.inited, (String)"The %s has not been initialized", (Object[])new Object[]{this});
    }

    private int superstepToResume() {
        return -1;
    }

    private boolean finishedIteration(boolean masterContinue, MasterComputationContext context) {
        if (!masterContinue) {
            return true;
        }
        if (context.superstep() >= this.maxSuperStep - 1) {
            return true;
        }
        long activeVertexCount = context.totalVertexCount() - context.finishedVertexCount();
        return context.messageCount() == 0L && activeVertexCount == 0L;
    }

    private SuperstepStat inputstep() {
        LOG.info("{} MasterService inputstep started", (Object)this);
        this.bsp4Master.waitWorkersInputDone();
        this.bsp4Master.masterInputDone();
        List<WorkerStat> workerStats = this.bsp4Master.waitWorkersStepDone(-1);
        SuperstepStat superstepStat = SuperstepStat.from(workerStats);
        this.bsp4Master.masterStepDone(-1, superstepStat);
        LOG.info("{} MasterService inputstep finished with superstat {}", (Object)this, (Object)superstepStat);
        return superstepStat;
    }

    private void outputstep() {
        LOG.info("{} MasterService outputstep started", (Object)this);
        this.bsp4Master.waitWorkersOutputDone();
        ComputerOutput output = (ComputerOutput)this.config.createObject(ComputerOptions.OUTPUT_CLASS);
        output.mergePartitions(this.config);
        LOG.info("{} MasterService outputstep finished", (Object)this);
    }

    private class SuperstepContext
    extends DefaultMasterContext
    implements MasterComputationContext {
        private final int superstep;
        private final SuperstepStat superstepStat;

        public SuperstepContext(int superstep, SuperstepStat superstepStat) {
            this.superstep = superstep;
            this.superstepStat = superstepStat;
        }

        public long totalVertexCount() {
            return this.superstepStat.vertexCount();
        }

        public long totalEdgeCount() {
            return this.superstepStat.edgeCount();
        }

        public long finishedVertexCount() {
            return this.superstepStat.finishedVertexCount();
        }

        public long messageCount() {
            return this.superstepStat.messageSendCount();
        }

        public long messageBytes() {
            return this.superstepStat.messageSendBytes();
        }

        public int superstep() {
            return this.superstep;
        }
    }

    private class DefaultMasterContext
    implements MasterContext {
        private final MasterAggrManager aggrManager;

        public DefaultMasterContext() {
            this.aggrManager = (MasterAggrManager)MasterService.this.managers.get("master_aggr");
        }

        public <V extends Value, C extends Aggregator<V>> void registerAggregator(String name, Class<C> aggregatorClass) {
            Aggregator aggr;
            E.checkArgument((aggregatorClass != null ? 1 : 0) != 0, (String)"The aggregator class can't be null", (Object[])new Object[0]);
            try {
                aggr = (Aggregator)aggregatorClass.newInstance();
            }
            catch (Exception e) {
                throw new ComputerException("Can't new instance from class: %s", (Throwable)e, new Object[]{aggregatorClass.getName()});
            }
            this.aggrManager.registerAggregator(name, aggr);
        }

        public <V extends Value, C extends Combiner<V>> void registerAggregator(String name, ValueType type, Class<C> combinerClass) {
            this.registerAggregator(name, type, combinerClass, null);
        }

        public <V extends Value, C extends Combiner<V>> void registerAggregator(String name, V defaultValue, Class<C> combinerClass) {
            E.checkArgument((defaultValue != null ? 1 : 0) != 0, (String)"The aggregator default value can't be null: %s, or call another register method if necessary: registerAggregator(String name,ValueType type,Class<C> combiner)", (Object[])new Object[]{name});
            this.registerAggregator(name, defaultValue.valueType(), combinerClass, defaultValue);
        }

        private <V extends Value, C extends Combiner<V>> void registerAggregator(String name, ValueType type, Class<C> combinerClass, V defaultValue) {
            DefaultAggregator<V> aggr = new DefaultAggregator<V>(MasterService.this.context, type, combinerClass, defaultValue);
            this.aggrManager.registerAggregator(name, aggr);
        }

        public <V extends Value> void aggregatedValue(String name, V value) {
            this.aggrManager.aggregatedAggregator(name, value);
        }

        public <V extends Value> V aggregatedValue(String name) {
            return this.aggrManager.aggregatedValue(name);
        }

        public Config config() {
            return MasterService.this.config;
        }
    }
}

