/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.common;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import org.apache.hugegraph.computer.core.common.exception.ComputerException;
import org.apache.hugegraph.util.CollectionUtil;

public interface SerialEnum {
    public static final Table<Class<?>, Byte, SerialEnum> TABLE = HashBasedTable.create();

    public byte code();

    public static void register(Class<? extends SerialEnum> clazz) {
        Object enums;
        try {
            enums = clazz.getMethod("values", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new ComputerException("Call method values() error", e);
        }
        for (SerialEnum e : CollectionUtil.toList((Object)enums)) {
            TABLE.put(clazz, (Object)e.code(), (Object)e);
        }
    }

    public static <T extends SerialEnum> T fromCode(Class<T> clazz, byte code) {
        SerialEnum value = (SerialEnum)TABLE.get(clazz, (Object)code);
        if (value == null) {
            throw new ComputerException("Can't construct %s from code %s", clazz.getSimpleName(), code);
        }
        return (T)value;
    }
}

