/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.lookout.api;

import com.alipay.lookout.api.Tag;
import com.alipay.lookout.common.Assert;
import java.util.Arrays;

public final class BasicTag
implements Tag {
    private final String key;
    private final String value;

    public BasicTag(String key, String value) {
        this.key = Assert.notNull(key, "tag key");
        this.value = value == null ? "" : value;
    }

    static BasicTag of(Tag tag) {
        return tag instanceof BasicTag ? (BasicTag)tag : new BasicTag(tag.key(), tag.value());
    }

    @Override
    public String key() {
        return this.key;
    }

    @Override
    public String value() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof BasicTag)) {
            return false;
        }
        BasicTag tag = (BasicTag)obj;
        return this.key.equals(tag.key) && this.value.equals(tag.value);
    }

    public int hashCode() {
        return Arrays.hashCode(new String[]{this.key, this.value});
    }

    public String toString() {
        return this.key + '=' + this.value;
    }
}

