/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.loader.reader.file;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.fs.Path;
import org.apache.hugegraph.loader.exception.LoadException;
import org.apache.hugegraph.loader.progress.FileItemProgress;
import org.apache.hugegraph.loader.progress.InputItemProgress;
import org.apache.hugegraph.loader.reader.Readable;
import org.apache.hugegraph.loader.reader.file.FileLineFetcher;
import org.apache.hugegraph.loader.reader.file.FileReader;
import org.apache.hugegraph.loader.reader.file.OrcFileLineFetcher;
import org.apache.hugegraph.loader.reader.file.ParquetFileLineFetcher;
import org.apache.hugegraph.loader.source.file.Compression;
import org.apache.hugegraph.loader.source.file.FileFilter;
import org.apache.hugegraph.loader.source.file.FileSource;

public class LocalFileReader
extends FileReader {
    public LocalFileReader(FileSource source) {
        super(source);
    }

    @Override
    protected List<Readable> scanReadables() {
        File file = FileUtils.getFile((String[])new String[]{this.source().path()});
        LocalFileReader.checkExistAndReadable(file);
        FileFilter filter = this.source().filter();
        ArrayList<Readable> files = new ArrayList<Readable>();
        if (file.isFile()) {
            if (!filter.reserved(file.getName())) {
                throw new LoadException("Please check file name and extensions, ensure that at least one file is available for reading");
            }
            files.add(new LocalFile(file));
        } else {
            assert (file.isDirectory());
            File[] subFiles = file.listFiles();
            if (subFiles == null) {
                throw new LoadException("Error while listing the files of path '%s'", file);
            }
            for (File subFile : subFiles) {
                if (!filter.reserved(subFile.getName())) continue;
                files.add(new LocalFile(subFile));
            }
        }
        return files;
    }

    @Override
    protected FileLineFetcher createLineFetcher() {
        if (Compression.ORC == this.source().compression()) {
            return new OrcFileLineFetcher(this.source());
        }
        if (Compression.PARQUET == this.source().compression()) {
            return new ParquetFileLineFetcher(this.source());
        }
        return new FileLineFetcher(this.source());
    }

    private static void checkExistAndReadable(File file) {
        if (!file.exists()) {
            throw new LoadException("Please ensure the file or directory exists: '%s'", file);
        }
        if (!file.canRead()) {
            throw new LoadException("Please ensure the file or directory is readable: '%s'", file);
        }
    }

    private static class LocalFile
    implements Readable {
        private final File file;

        public LocalFile(File file) {
            this.file = file;
        }

        public File file() {
            return this.file;
        }

        @Override
        public String name() {
            return this.file.getName();
        }

        @Override
        public Path path() {
            return new Path(this.file().getPath());
        }

        @Override
        public InputStream open() throws IOException {
            return Files.newInputStream(this.file.toPath(), new OpenOption[0]);
        }

        @Override
        public InputItemProgress inputItemProgress() {
            String checkSum;
            String name = this.file.getName();
            long timestamp = this.file.lastModified();
            try {
                checkSum = String.valueOf(FileUtils.checksumCRC32((File)this.file));
            }
            catch (IOException e) {
                throw new LoadException("Failed to calculate checksum for local file '%s'", (Throwable)e, this.file);
            }
            return new FileItemProgress(name, timestamp, checkSum, 0L);
        }

        public String toString() {
            return "FILE: " + this.file;
        }
    }
}

