/*
 * Decompiled with CFR 0.152.
 */
package javolution.context;

import javolution.context.Allocator;
import javolution.context.Context;
import javolution.context.HeapContext;
import javolution.context.ObjectFactory;
import javolution.lang.Configurable;
import javolution.lang.ValueType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AllocatorContext
extends Context {
    private static volatile AllocatorContext _Default = new HeapContext();
    public static final Configurable<Class<? extends AllocatorContext>> DEFAULT = new Configurable(HeapContext.class){

        protected void notifyChange(Object oldValue, Object newValue) {
            _Default = (AllocatorContext)ObjectFactory.getInstance((Class)newValue).object();
        }
    };

    protected AllocatorContext() {
    }

    public static AllocatorContext getCurrentAllocatorContext() {
        return Context.getCurrentContext().getAllocatorContext();
    }

    public static AllocatorContext getDefault() {
        return _Default;
    }

    protected abstract Allocator getAllocator(ObjectFactory var1);

    protected abstract void deactivate();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends ValueType> T outerCopy(T value) {
        Context.enter(OuterContext.class);
        try {
            Object copy = value.copy();
            ValueType valueType = (ValueType)copy;
            return (T)valueType;
        }
        finally {
            Context.exit(OuterContext.class);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void outerCopy(ValueType[] values) {
        Context.enter(OuterContext.class);
        try {
            for (int i = 0; i < values.length; ++i) {
                values[i] = (ValueType)values[i].copy();
            }
        }
        finally {
            Context.exit(OuterContext.class);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void outerExecute(Runnable logic) {
        Context.enter(OuterContext.class);
        try {
            logic.run();
        }
        finally {
            Context.exit(OuterContext.class);
        }
    }

    static {
        ObjectFactory.setInstance(new ObjectFactory(){

            protected Object create() {
                return new OuterContext();
            }
        }, OuterContext.class);
    }

    private static class OuterContext
    extends AllocatorContext {
        private AllocatorContext _outer;
        private AllocatorContext _outerOuter;

        private OuterContext() {
        }

        protected Allocator getAllocator(ObjectFactory factory) {
            return this._outerOuter.getAllocator(factory);
        }

        protected void deactivate() {
            this._outerOuter.deactivate();
        }

        protected void enterAction() {
            this._outer = this.getOuter().getAllocatorContext();
            Context outer = this._outer.getOuter();
            if (outer == null) {
                this._outerOuter = this._outer;
            } else {
                this._outerOuter = outer.getAllocatorContext();
                this._outer.deactivate();
            }
        }

        protected void exitAction() {
            if (this._outer != this._outerOuter) {
                this._outerOuter.deactivate();
            }
            this._outer = null;
            this._outerOuter = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Reference<T>
    implements javolution.lang.Reference<T> {
        private static final ObjectFactory FACTORY = new ObjectFactory(){

            protected Object create() {
                return new Reference();
            }

            protected void cleanup(Object obj) {
                ((Reference)obj)._value = null;
            }
        };
        private T _value;

        public static <T> Reference<T> newInstance() {
            return (Reference)FACTORY.object();
        }

        public String toString() {
            return String.valueOf(this._value);
        }

        @Override
        public final T get() {
            return this._value;
        }

        @Override
        public final void set(T value) {
            this._value = value;
        }
    }
}

