/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.entity.load;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.handlers.JacksonTypeHandler;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hugegraph.annotation.MergeProperty;
import org.apache.hugegraph.entity.enums.FileMappingStatus;
import org.apache.hugegraph.entity.load.EdgeMapping;
import org.apache.hugegraph.entity.load.ElementMapping;
import org.apache.hugegraph.entity.load.FileSetting;
import org.apache.hugegraph.entity.load.LoadParameter;
import org.apache.hugegraph.entity.load.VertexMapping;
import org.apache.hugegraph.handler.EdgeMappingTypeHandler;
import org.apache.hugegraph.handler.VertexMappingTypeHandler;
import org.apache.hugegraph.util.HubbleUtil;
import org.apache.hugegraph.util.SerializeUtil;

@TableName(value="file_mapping", autoResultMap=true)
public class FileMapping {
    @TableId(type=IdType.AUTO)
    @JsonProperty(value="id")
    private Integer id;
    @TableField(value="conn_id")
    @JsonIgnore
    private Integer connId;
    @TableField(value="job_id")
    @MergeProperty
    @JsonProperty(value="job_id")
    private Integer jobId;
    @TableField(value="name")
    @JsonProperty(value="name")
    private String name;
    @TableField(value="path")
    @JsonIgnore
    private String path;
    @TableField(value="total_lines")
    @JsonProperty(value="total_lines")
    private long totalLines;
    @TableField(value="total_size")
    @JsonProperty(value="total_size")
    @JsonSerialize(using=SerializeUtil.SizeSerializer.class)
    private long totalSize;
    @TableField(value="file_status")
    @MergeProperty
    @JsonProperty(value="file_status")
    private FileMappingStatus fileStatus;
    @TableField(value="file_setting", typeHandler=JacksonTypeHandler.class)
    @JsonProperty(value="file_setting")
    private FileSetting fileSetting;
    @TableField(value="vertex_mappings", typeHandler=VertexMappingTypeHandler.class)
    @JsonProperty(value="vertex_mappings")
    private Set<VertexMapping> vertexMappings;
    @TableField(value="edge_mappings", typeHandler=EdgeMappingTypeHandler.class)
    @JsonProperty(value="edge_mappings")
    private Set<EdgeMapping> edgeMappings;
    @TableField(value="load_parameter", typeHandler=JacksonTypeHandler.class)
    @JsonProperty(value="load_parameter")
    private LoadParameter loadParameter;
    @MergeProperty(useNew=false)
    @JsonProperty(value="create_time")
    private Date createTime;
    @MergeProperty(useNew=false)
    @JsonProperty(value="update_time")
    private Date updateTime;

    public FileMapping(int connId, String name, String path) {
        this(connId, name, path, HubbleUtil.nowDate());
    }

    public FileMapping(int connId, String name, String path, Date lastAccessTime) {
        this.id = null;
        this.connId = connId;
        this.name = name;
        this.path = path;
        this.fileSetting = new FileSetting();
        this.vertexMappings = new LinkedHashSet<VertexMapping>();
        this.edgeMappings = new LinkedHashSet<EdgeMapping>();
        this.loadParameter = new LoadParameter();
        this.createTime = lastAccessTime;
        this.updateTime = lastAccessTime;
    }

    public VertexMapping getVertexMapping(String vmId) {
        for (VertexMapping mapping : this.vertexMappings) {
            if (!mapping.getId().equals(vmId)) continue;
            return mapping;
        }
        return null;
    }

    public EdgeMapping getEdgeMapping(String emId) {
        for (EdgeMapping mapping : this.edgeMappings) {
            if (!mapping.getId().equals(emId)) continue;
            return mapping;
        }
        return null;
    }

    @JsonIgnore
    public Set<String> getVertexMappingLabels() {
        if (this.getVertexMappings() == null) {
            return new HashSet<String>();
        }
        return this.getVertexMappings().stream().map(ElementMapping::getLabel).collect(Collectors.toSet());
    }

    @JsonIgnore
    public Set<String> getEdgeMappingLabels() {
        if (this.getEdgeMappings() == null) {
            return new HashSet<String>();
        }
        return this.getEdgeMappings().stream().map(ElementMapping::getLabel).collect(Collectors.toSet());
    }

    public static FileMappingBuilder builder() {
        return new FileMappingBuilder();
    }

    public Integer getId() {
        return this.id;
    }

    public Integer getConnId() {
        return this.connId;
    }

    public Integer getJobId() {
        return this.jobId;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public long getTotalLines() {
        return this.totalLines;
    }

    public long getTotalSize() {
        return this.totalSize;
    }

    public FileMappingStatus getFileStatus() {
        return this.fileStatus;
    }

    public FileSetting getFileSetting() {
        return this.fileSetting;
    }

    public Set<VertexMapping> getVertexMappings() {
        return this.vertexMappings;
    }

    public Set<EdgeMapping> getEdgeMappings() {
        return this.edgeMappings;
    }

    public LoadParameter getLoadParameter() {
        return this.loadParameter;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public Date getUpdateTime() {
        return this.updateTime;
    }

    @JsonProperty(value="id")
    public FileMapping setId(Integer id) {
        this.id = id;
        return this;
    }

    public FileMapping setConnId(Integer connId) {
        this.connId = connId;
        return this;
    }

    @JsonProperty(value="job_id")
    public FileMapping setJobId(Integer jobId) {
        this.jobId = jobId;
        return this;
    }

    @JsonProperty(value="name")
    public FileMapping setName(String name) {
        this.name = name;
        return this;
    }

    public FileMapping setPath(String path) {
        this.path = path;
        return this;
    }

    @JsonProperty(value="total_lines")
    public FileMapping setTotalLines(long totalLines) {
        this.totalLines = totalLines;
        return this;
    }

    @JsonProperty(value="total_size")
    public FileMapping setTotalSize(long totalSize) {
        this.totalSize = totalSize;
        return this;
    }

    @JsonProperty(value="file_status")
    public FileMapping setFileStatus(FileMappingStatus fileStatus) {
        this.fileStatus = fileStatus;
        return this;
    }

    @JsonProperty(value="file_setting")
    public FileMapping setFileSetting(FileSetting fileSetting) {
        this.fileSetting = fileSetting;
        return this;
    }

    @JsonProperty(value="vertex_mappings")
    public FileMapping setVertexMappings(Set<VertexMapping> vertexMappings) {
        this.vertexMappings = vertexMappings;
        return this;
    }

    @JsonProperty(value="edge_mappings")
    public FileMapping setEdgeMappings(Set<EdgeMapping> edgeMappings) {
        this.edgeMappings = edgeMappings;
        return this;
    }

    @JsonProperty(value="load_parameter")
    public FileMapping setLoadParameter(LoadParameter loadParameter) {
        this.loadParameter = loadParameter;
        return this;
    }

    @JsonProperty(value="create_time")
    public FileMapping setCreateTime(Date createTime) {
        this.createTime = createTime;
        return this;
    }

    @JsonProperty(value="update_time")
    public FileMapping setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FileMapping)) {
            return false;
        }
        FileMapping other = (FileMapping)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$id = this.getId();
        Integer other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Integer this$connId = this.getConnId();
        Integer other$connId = other.getConnId();
        if (this$connId == null ? other$connId != null : !((Object)this$connId).equals(other$connId)) {
            return false;
        }
        Integer this$jobId = this.getJobId();
        Integer other$jobId = other.getJobId();
        if (this$jobId == null ? other$jobId != null : !((Object)this$jobId).equals(other$jobId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        if (this.getTotalLines() != other.getTotalLines()) {
            return false;
        }
        if (this.getTotalSize() != other.getTotalSize()) {
            return false;
        }
        FileMappingStatus this$fileStatus = this.getFileStatus();
        FileMappingStatus other$fileStatus = other.getFileStatus();
        if (this$fileStatus == null ? other$fileStatus != null : !((Object)((Object)this$fileStatus)).equals((Object)other$fileStatus)) {
            return false;
        }
        FileSetting this$fileSetting = this.getFileSetting();
        FileSetting other$fileSetting = other.getFileSetting();
        if (this$fileSetting == null ? other$fileSetting != null : !((Object)this$fileSetting).equals(other$fileSetting)) {
            return false;
        }
        Set<VertexMapping> this$vertexMappings = this.getVertexMappings();
        Set<VertexMapping> other$vertexMappings = other.getVertexMappings();
        if (this$vertexMappings == null ? other$vertexMappings != null : !((Object)this$vertexMappings).equals(other$vertexMappings)) {
            return false;
        }
        Set<EdgeMapping> this$edgeMappings = this.getEdgeMappings();
        Set<EdgeMapping> other$edgeMappings = other.getEdgeMappings();
        if (this$edgeMappings == null ? other$edgeMappings != null : !((Object)this$edgeMappings).equals(other$edgeMappings)) {
            return false;
        }
        LoadParameter this$loadParameter = this.getLoadParameter();
        LoadParameter other$loadParameter = other.getLoadParameter();
        if (this$loadParameter == null ? other$loadParameter != null : !((Object)this$loadParameter).equals(other$loadParameter)) {
            return false;
        }
        Date this$createTime = this.getCreateTime();
        Date other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        Date this$updateTime = this.getUpdateTime();
        Date other$updateTime = other.getUpdateTime();
        return !(this$updateTime == null ? other$updateTime != null : !((Object)this$updateTime).equals(other$updateTime));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FileMapping;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Integer $connId = this.getConnId();
        result = result * 59 + ($connId == null ? 43 : ((Object)$connId).hashCode());
        Integer $jobId = this.getJobId();
        result = result * 59 + ($jobId == null ? 43 : ((Object)$jobId).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        long $totalLines = this.getTotalLines();
        result = result * 59 + (int)($totalLines >>> 32 ^ $totalLines);
        long $totalSize = this.getTotalSize();
        result = result * 59 + (int)($totalSize >>> 32 ^ $totalSize);
        FileMappingStatus $fileStatus = this.getFileStatus();
        result = result * 59 + ($fileStatus == null ? 43 : ((Object)((Object)$fileStatus)).hashCode());
        FileSetting $fileSetting = this.getFileSetting();
        result = result * 59 + ($fileSetting == null ? 43 : ((Object)$fileSetting).hashCode());
        Set<VertexMapping> $vertexMappings = this.getVertexMappings();
        result = result * 59 + ($vertexMappings == null ? 43 : ((Object)$vertexMappings).hashCode());
        Set<EdgeMapping> $edgeMappings = this.getEdgeMappings();
        result = result * 59 + ($edgeMappings == null ? 43 : ((Object)$edgeMappings).hashCode());
        LoadParameter $loadParameter = this.getLoadParameter();
        result = result * 59 + ($loadParameter == null ? 43 : ((Object)$loadParameter).hashCode());
        Date $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        Date $updateTime = this.getUpdateTime();
        result = result * 59 + ($updateTime == null ? 43 : ((Object)$updateTime).hashCode());
        return result;
    }

    public String toString() {
        return "FileMapping(id=" + this.getId() + ", connId=" + this.getConnId() + ", jobId=" + this.getJobId() + ", name=" + this.getName() + ", path=" + this.getPath() + ", totalLines=" + this.getTotalLines() + ", totalSize=" + this.getTotalSize() + ", fileStatus=" + (Object)((Object)this.getFileStatus()) + ", fileSetting=" + this.getFileSetting() + ", vertexMappings=" + this.getVertexMappings() + ", edgeMappings=" + this.getEdgeMappings() + ", loadParameter=" + this.getLoadParameter() + ", createTime=" + this.getCreateTime() + ", updateTime=" + this.getUpdateTime() + ")";
    }

    public FileMapping() {
    }

    public FileMapping(Integer id, Integer connId, Integer jobId, String name, String path, long totalLines, long totalSize, FileMappingStatus fileStatus, FileSetting fileSetting, Set<VertexMapping> vertexMappings, Set<EdgeMapping> edgeMappings, LoadParameter loadParameter, Date createTime, Date updateTime) {
        this.id = id;
        this.connId = connId;
        this.jobId = jobId;
        this.name = name;
        this.path = path;
        this.totalLines = totalLines;
        this.totalSize = totalSize;
        this.fileStatus = fileStatus;
        this.fileSetting = fileSetting;
        this.vertexMappings = vertexMappings;
        this.edgeMappings = edgeMappings;
        this.loadParameter = loadParameter;
        this.createTime = createTime;
        this.updateTime = updateTime;
    }

    public static class FileMappingBuilder {
        private Integer id;
        private Integer connId;
        private Integer jobId;
        private String name;
        private String path;
        private long totalLines;
        private long totalSize;
        private FileMappingStatus fileStatus;
        private FileSetting fileSetting;
        private Set<VertexMapping> vertexMappings;
        private Set<EdgeMapping> edgeMappings;
        private LoadParameter loadParameter;
        private Date createTime;
        private Date updateTime;

        FileMappingBuilder() {
        }

        @JsonProperty(value="id")
        public FileMappingBuilder id(Integer id) {
            this.id = id;
            return this;
        }

        public FileMappingBuilder connId(Integer connId) {
            this.connId = connId;
            return this;
        }

        @JsonProperty(value="job_id")
        public FileMappingBuilder jobId(Integer jobId) {
            this.jobId = jobId;
            return this;
        }

        @JsonProperty(value="name")
        public FileMappingBuilder name(String name) {
            this.name = name;
            return this;
        }

        public FileMappingBuilder path(String path) {
            this.path = path;
            return this;
        }

        @JsonProperty(value="total_lines")
        public FileMappingBuilder totalLines(long totalLines) {
            this.totalLines = totalLines;
            return this;
        }

        @JsonProperty(value="total_size")
        public FileMappingBuilder totalSize(long totalSize) {
            this.totalSize = totalSize;
            return this;
        }

        @JsonProperty(value="file_status")
        public FileMappingBuilder fileStatus(FileMappingStatus fileStatus) {
            this.fileStatus = fileStatus;
            return this;
        }

        @JsonProperty(value="file_setting")
        public FileMappingBuilder fileSetting(FileSetting fileSetting) {
            this.fileSetting = fileSetting;
            return this;
        }

        @JsonProperty(value="vertex_mappings")
        public FileMappingBuilder vertexMappings(Set<VertexMapping> vertexMappings) {
            this.vertexMappings = vertexMappings;
            return this;
        }

        @JsonProperty(value="edge_mappings")
        public FileMappingBuilder edgeMappings(Set<EdgeMapping> edgeMappings) {
            this.edgeMappings = edgeMappings;
            return this;
        }

        @JsonProperty(value="load_parameter")
        public FileMappingBuilder loadParameter(LoadParameter loadParameter) {
            this.loadParameter = loadParameter;
            return this;
        }

        @JsonProperty(value="create_time")
        public FileMappingBuilder createTime(Date createTime) {
            this.createTime = createTime;
            return this;
        }

        @JsonProperty(value="update_time")
        public FileMappingBuilder updateTime(Date updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public FileMapping build() {
            return new FileMapping(this.id, this.connId, this.jobId, this.name, this.path, this.totalLines, this.totalSize, this.fileStatus, this.fileSetting, this.vertexMappings, this.edgeMappings, this.loadParameter, this.createTime, this.updateTime);
        }

        public String toString() {
            return "FileMapping.FileMappingBuilder(id=" + this.id + ", connId=" + this.connId + ", jobId=" + this.jobId + ", name=" + this.name + ", path=" + this.path + ", totalLines=" + this.totalLines + ", totalSize=" + this.totalSize + ", fileStatus=" + (Object)((Object)this.fileStatus) + ", fileSetting=" + this.fileSetting + ", vertexMappings=" + this.vertexMappings + ", edgeMappings=" + this.edgeMappings + ", loadParameter=" + this.loadParameter + ", createTime=" + this.createTime + ", updateTime=" + this.updateTime + ")";
        }
    }
}

