/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.stream.plugin.es;

import cn.hutool.core.collection.ListUtil;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.xiaomi.mone.es.EsProcessor;
import com.xiaomi.youpin.docean.anno.Service;
import com.xiaomi.youpin.docean.plugin.es.EsProcessorConf;
import com.xiaomi.youpin.docean.plugin.es.EsService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.ozhera.log.common.Config;
import org.apache.ozhera.log.common.Constant;
import org.apache.ozhera.log.model.StorageInfo;
import org.apache.ozhera.log.stream.job.compensate.MqMessageDTO;
import org.apache.ozhera.log.stream.plugin.es.EsConfig;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkProcessor;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
public class EsPlugin {
    private static final Logger log = LoggerFactory.getLogger(EsPlugin.class);
    private static EsConfig esConfig;
    private static ConcurrentHashMap<String, EsService> esServiceMap;
    private static ConcurrentHashMap<String, List<Pair<EsProcessor, Integer>>> esProcessorMap;
    public static final int SINGLE_MESSAGE_BYTES_MAXIMAL = 0xA00000;
    private static int DEFAULT_PROCESSOR_COUNT;
    private static ReentrantLock esLock;
    private static Gson gson;

    public static boolean InitEsConfig() {
        EsConfig config = new EsConfig();
        Config ins = Config.ins();
        try {
            config.setBulkActions(Integer.parseInt(ins.get("es.bulk_actions", "100")));
            config.setByteSize(Long.parseLong(ins.get("es.byte_size", "5")));
            config.setConcurrentRequest(Integer.parseInt(ins.get("es.concurrent_request", "10")));
            config.setFlushInterval(Integer.parseInt(ins.get("es.flush_interval", "")));
            config.setRetryNumber(Integer.parseInt(ins.get("es.retry_num", "3")));
            config.setRetryInterval(Integer.parseInt(ins.get("es.retry_interval", "3")));
            DEFAULT_PROCESSOR_COUNT = Integer.parseInt(ins.get("es.processor_count", String.valueOf(DEFAULT_PROCESSOR_COUNT)));
            log.info("[EsPlugin.getEsProcessor] init es config:{}", (Object)config);
        }
        catch (Exception e) {
            log.error("[EsPlugin.InitEsConfig] init es config err:", (Throwable)e);
            return false;
        }
        esConfig = config;
        return true;
    }

    public static EsProcessor getEsProcessor(StorageInfo esInfo, Consumer<MqMessageDTO> onFailedConsumer) {
        return EsPlugin.getEsProcessor(esInfo, esConfig, onFailedConsumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EsProcessor getEsProcessor(StorageInfo esInfo, EsConfig config, Consumer<MqMessageDTO> onFailedConsumer) {
        List<Pair<EsProcessor, Integer>> esProcessorList = esProcessorMap.get(EsPlugin.cacheKey(esInfo));
        if (CollectionUtils.isEmpty(esProcessorList)) {
            esLock.lock();
            try {
                EsService esService = esServiceMap.get(EsPlugin.cacheKey(esInfo));
                if (esService == null) {
                    log.info("init es service started,esInfo:{}", (Object)Constant.GSON.toJson((Object)esInfo));
                    esService = StringUtils.isNotBlank((CharSequence)esInfo.getUser()) && StringUtils.isNotBlank((CharSequence)esInfo.getPwd()) ? new EsService(esInfo.getAddr(), esInfo.getUser(), esInfo.getPwd()) : (StringUtils.isNotBlank((CharSequence)esInfo.getToken()) ? new EsService(esInfo.getAddr(), esInfo.getToken(), esInfo.getCatalog(), esInfo.getDatabase()) : new EsService(esInfo.getAddr(), esInfo.getUser(), esInfo.getPwd()));
                    log.info("init es service finished,esInfo:{}", (Object)Constant.GSON.toJson((Object)esInfo));
                    esServiceMap.put(EsPlugin.cacheKey(esInfo), esService);
                }
                esProcessorList = new ArrayList<Pair<EsProcessor, Integer>>();
                for (int i = 0; i < DEFAULT_PROCESSOR_COUNT; ++i) {
                    EsProcessor esProcessor = EsPlugin.buildEsProcessor(esInfo, config, onFailedConsumer, esService);
                    esProcessorList.add((Pair<EsProcessor, Integer>)MutablePair.of((Object)esProcessor, (Object)0));
                }
                esProcessorMap.put(EsPlugin.cacheKey(esInfo), esProcessorList);
            }
            finally {
                esLock.unlock();
            }
        }
        return EsPlugin.getLeastUsedEsProcessor(esProcessorMap.get(EsPlugin.cacheKey(esInfo)));
    }

    private static EsProcessor getLeastUsedEsProcessor(List<Pair<EsProcessor, Integer>> esProcessorList) {
        ArrayList<Pair<EsProcessor, Integer>> unmodifiableEsProcessorList = new ArrayList<Pair<EsProcessor, Integer>>(esProcessorList);
        Collections.sort(unmodifiableEsProcessorList, Comparator.comparingInt(Pair::getValue));
        Pair esProcessorIntegerPair = (Pair)unmodifiableEsProcessorList.get(0);
        esProcessorIntegerPair.setValue((Object)((Integer)esProcessorIntegerPair.getValue() + 1));
        return (EsProcessor)esProcessorIntegerPair.getKey();
    }

    private static void sendMessageToTopic(BulkRequest request, StorageInfo esInfo, Consumer<MqMessageDTO> onFailedConsumer) {
        String enable = Config.ins().get("hera.stream.compensate.message.enable", "");
        if (StringUtils.isNotBlank((CharSequence)enable) && StringUtils.equalsIgnoreCase((CharSequence)enable, (CharSequence)"false")) {
            log.warn("[EsPlugin.sendMessageToTopic] hera.stream.compensate.message,enable is false,do not send message to topic,enable:{}", (Object)enable);
            return;
        }
        MqMessageDTO MqMessageDTO2 = new MqMessageDTO();
        MqMessageDTO2.setEsInfo(esInfo);
        ArrayList compensateMqDTOS = Lists.newArrayList();
        request.requests().stream().filter(x -> x instanceof IndexRequest).forEach(x -> {
            Map source = ((IndexRequest)x).sourceAsMap();
            log.error("Failure to handle index:[{}], type:[{}],id:[{}] data:[{}]", new Object[]{x.index(), x.type(), x.id(), JSON.toJSONString((Object)source)});
            MqMessageDTO.CompensateMqDTO compensateMqDTO = new MqMessageDTO.CompensateMqDTO();
            compensateMqDTO.setMsg(JSON.toJSONString((Object)source));
            compensateMqDTO.setEsIndex(x.index());
            compensateMqDTOS.add(compensateMqDTO);
        });
        int length = JSON.toJSONString((Object)compensateMqDTOS).getBytes().length;
        if (length > 0xA00000) {
            List splitList = ListUtil.partition((List)compensateMqDTOS, (int)2);
            for (List mqDTOS : splitList) {
                MqMessageDTO2.setCompensateMqDTOS(mqDTOS);
                onFailedConsumer.accept(MqMessageDTO2);
            }
        } else {
            MqMessageDTO2.setCompensateMqDTOS(compensateMqDTOS);
            onFailedConsumer.accept(MqMessageDTO2);
        }
    }

    private static EsProcessor buildEsProcessor(final StorageInfo esInfo, EsConfig config, final Consumer<MqMessageDTO> onFailedConsumer, EsService esService) {
        final AtomicLong errorCount = new AtomicLong(0L);
        EsProcessor esProcessor = esService.getEsProcessor(new EsProcessorConf(config.getBulkActions(), config.getByteSize(), config.getConcurrentRequest(), config.getFlushInterval(), config.getRetryNumber(), config.getRetryInterval(), new BulkProcessor.Listener(){

            public void beforeBulk(long executionId, BulkRequest request) {
            }

            public void afterBulk(long executionId, BulkRequest request, BulkResponse response) {
                if (response.hasFailures()) {
                    log.error("afterBulk request:{},response:{}", (Object)((DocWriteRequest)request.requests().getFirst()).toString(), (Object)response.buildFailureMessage());
                    AtomicInteger count = new AtomicInteger();
                    response.spliterator().forEachRemaining(x -> {
                        if (x.isFailed()) {
                            BulkItemResponse.Failure failure = x.getFailure();
                            String msg = String.format("Index:[%s], type:[%s], id:[%s], itemId:[%s], opt:[%s], version:[%s], errMsg:%s", x.getIndex(), x.getType(), x.getId(), x.getItemId(), x.getOpType().getLowercase(), x.getVersion(), failure.getCause().getMessage());
                            log.error("esInfo:{},Bulk executionId:[{}] has error messages:{}", new Object[]{Constant.GSON.toJson((Object)esInfo), executionId, msg});
                            count.incrementAndGet();
                        }
                    });
                    log.debug("Finished handling bulk commit executionId:[{}] for {} requests with {} errors,esInfo:{}", new Object[]{executionId, request.numberOfActions(), count.intValue(), Constant.GSON.toJson((Object)esInfo)});
                } else {
                    log.debug("success send to es,desc:{}", (Object)request.getDescription());
                }
            }

            public void afterBulk(long executionId, BulkRequest request, Throwable failure) {
                if (failure instanceof IOException && failure.getMessage().contains("Unable to parse response body for")) {
                    long errorDecrement = errorCount.getAndDecrement();
                    if (errorDecrement == 0L || errorDecrement % 500L == 0L) {
                        log.error("afterBulk response error", failure);
                    }
                    return;
                }
                log.error(String.format("fail send %s message to es,desc:%s,es addr:%s", request.numberOfActions(), request.getDescription(), esInfo.getAddr()), (Throwable)new RuntimeException(failure));
                Class<?> clazz = failure.getClass();
                log.error("Bulk [{}] finished with [{}] requests of error:{}, {}, {}:-[{}]", new Object[]{executionId, request.numberOfActions(), clazz.getName(), clazz.getSimpleName(), clazz.getTypeName(), clazz.getCanonicalName(), failure.getMessage()});
                EsPlugin.sendMessageToTopic(request, esInfo, onFailedConsumer);
            }
        }));
        return esProcessor;
    }

    private static String cacheKey(StorageInfo esInfo) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(esInfo.getId()).append(",");
        stringBuilder.append(esInfo.getAddr());
        if (StringUtils.isNotBlank((CharSequence)esInfo.getUser())) {
            stringBuilder.append(",").append(esInfo.getUser());
        }
        if (StringUtils.isNotBlank((CharSequence)esInfo.getPwd())) {
            stringBuilder.append(",").append(esInfo.getPwd());
        }
        if (StringUtils.isNotBlank((CharSequence)esInfo.getToken())) {
            stringBuilder.append(",").append(esInfo.getToken());
        }
        if (StringUtils.isNotBlank((CharSequence)esInfo.getCatalog())) {
            stringBuilder.append(",").append(esInfo.getCatalog());
        }
        if (StringUtils.isNotBlank((CharSequence)esInfo.getDatabase())) {
            stringBuilder.append(",").append(esInfo.getDatabase());
        }
        return stringBuilder.toString();
    }

    static {
        esServiceMap = new ConcurrentHashMap();
        esProcessorMap = new ConcurrentHashMap();
        DEFAULT_PROCESSOR_COUNT = 1;
        esLock = new ReentrantLock();
        gson = new Gson();
    }
}

