/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.monitor.service.api.impl;

import com.alibaba.nacos.api.config.annotation.NacosValue;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.app.api.message.HeraAppInfoModifyMessage;
import org.apache.ozhera.monitor.bo.GrafanaInterfaceRes;
import org.apache.ozhera.monitor.dao.model.AppMonitor;
import org.apache.ozhera.monitor.result.ErrorCode;
import org.apache.ozhera.monitor.result.Result;
import org.apache.ozhera.monitor.service.api.AppMonitorServiceExtension;
import org.apache.ozhera.monitor.service.model.ProjectInfo;
import org.apache.ozhera.monitor.utils.FreeMarkerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(name={"service.selector.property"}, havingValue="outer")
public class AppMonitorServiceExtensionImpl
implements AppMonitorServiceExtension {
    private static final Logger log = LoggerFactory.getLogger(AppMonitorServiceExtensionImpl.class);
    @NacosValue(value="${grafana.domain}", autoRefreshed=true)
    private String grafanaDomain;
    private String resourceUrl = "/d/hera-resource-utilization/hera-k8szi-yuan-shi-yong-lu-da-pan?orgId=1&var-application=";
    private String dubboProviderOverview = "/d/hera-dubboprovider-overview/hera-dubboproviderzong-lan?orgId=1&kiosk&theme=light";
    private String dubboConsumerOverview = "/d/hera-dubboconsumer-overview/hera-dubboconsumerzong-lan?orgId=1&kiosk&theme=light";
    private String dubboProviderMarket = "/d/Hera-DubboProviderMarket/hera-dubboproviderda-pan?orgId=1&kiosk&theme=light";
    private String dubboConsumerMarket = "/d/Hera-DubboConsumerMarket/hera-dubboconsumerda-pan?orgId=1&kiosk&theme=light";
    private String httpOverview = "/d/Hera-HTTPServer-overview/hera-httpserver-zong-lan?orgId=1&kiosk&theme=light";
    private String httpMarket = "/d/Hera-HTTPServerMarket/hera-httpserverda-pan?orgId=1&kiosk&theme=light";
    private String grpcProviderOverview = "/d/hera-grpcprovider-overview/hera-grpcproviderzong-lan?orgId=1&kiosk&theme=light";
    private String grpcProviderMarket = "/d/hera-grpcproviderMarket/hera-grpcproviderda-pan?orgId=1&kiosk&theme=light";
    private String grpcConsumerOverview = "/d/hera-grpcconsumer-overview/hera-grpcconsumerzong-lan?orgId=1&kiosk&theme=light";
    private String grpcConsumerMarket = "/d/hera-grpcconsumerMarket/hera-grpcconsumerda-pan?orgId=1&kiosk&theme=light";
    private static final Gson gson = new Gson();

    @Override
    public Result getResourceUsageUrlForK8s(Integer appId, String appName) {
        String application = String.valueOf(appId) + "_" + StringUtils.replace((String)appName, (String)"-", (String)"_");
        String url = this.grafanaDomain + this.resourceUrl + application;
        log.info("getResourceUsageUrlForK8s url:{}", (Object)url);
        return Result.success((Object)url);
    }

    @Override
    public Result grafanaInterfaceList() {
        HashMap<String, CallSite> map = new HashMap<String, CallSite>();
        map.put("dubboProviderOverview", (CallSite)((Object)(this.grafanaDomain + this.dubboProviderOverview)));
        map.put("dubboConsumerOverview", (CallSite)((Object)(this.grafanaDomain + this.dubboConsumerOverview)));
        map.put("dubboProviderMarket", (CallSite)((Object)(this.grafanaDomain + this.dubboProviderMarket)));
        map.put("dubboConsumerMarket", (CallSite)((Object)(this.grafanaDomain + this.dubboConsumerMarket)));
        map.put("httpOverview", (CallSite)((Object)(this.grafanaDomain + this.httpOverview)));
        map.put("httpMarket", (CallSite)((Object)(this.grafanaDomain + this.httpMarket)));
        map.put("grpcProviderOverview", (CallSite)((Object)(this.grafanaDomain + this.grpcProviderOverview)));
        map.put("grpcProviderMarket", (CallSite)((Object)(this.grafanaDomain + this.grpcProviderMarket)));
        map.put("grpcConsumerOverview", (CallSite)((Object)(this.grafanaDomain + this.grpcConsumerOverview)));
        map.put("grpcConsumerMarket", (CallSite)((Object)(this.grafanaDomain + this.grpcConsumerMarket)));
        try {
            log.info("grafanaInterfaceList map:{}", map);
            String data = FreeMarkerUtil.getContentExceptJson((String)"/heraGrafanaTemplate", (String)"grafanaInterfaceList.ftl", map);
            JsonArray jsonElements = (JsonArray)gson.fromJson(data, JsonArray.class);
            log.info(jsonElements.toString());
            ArrayList resList = new ArrayList();
            jsonElements.forEach(it -> {
                GrafanaInterfaceRes grafanaInterfaceRes = (GrafanaInterfaceRes)gson.fromJson(it, GrafanaInterfaceRes.class);
                resList.add(grafanaInterfaceRes);
            });
            log.info("grafanaInterfaceList success! data:{}", resList);
            return Result.success(resList);
        }
        catch (Exception e) {
            log.error("grafanaInterfaceList error! {}", (Throwable)e);
            return Result.fail((ErrorCode)ErrorCode.unknownError);
        }
    }

    @Override
    public Result initAppsByUsername(String userName) {
        return null;
    }

    @Override
    public List<ProjectInfo> getAppsByUserName(String username) {
        return null;
    }

    @Override
    public Boolean checkCreateParam(AppMonitor appMonitor) {
        if (appMonitor.getProjectId() == null || StringUtils.isBlank((CharSequence)appMonitor.getProjectName())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean checkAppModifyStrategySearchCondition(HeraAppInfoModifyMessage message) {
        if (message.getAppId() == null) {
            log.error("checkAppModifyStrategySearchCondition appId is null message : {}", (Object)message);
            return false;
        }
        return true;
    }

    @Override
    public void changeAlarmServiceToZone(Integer pageSize, String appName) {
    }

    @Override
    public Result getResourceUsageUrl(Integer appId, String appName) {
        return null;
    }
}

