/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.data.push.rpc;

import com.xiaomi.data.push.bo.User;
import com.xiaomi.data.push.context.AgentContext;
import com.xiaomi.data.push.rpc.common.InvokeCallback;
import com.xiaomi.data.push.rpc.common.RemotingUtil;
import com.xiaomi.data.push.rpc.exception.RemotingSendRequestException;
import com.xiaomi.data.push.rpc.exception.RemotingTimeoutException;
import com.xiaomi.data.push.rpc.exception.RemotingTooMuchRequestException;
import com.xiaomi.data.push.rpc.netty.AgentChannel;
import com.xiaomi.data.push.rpc.netty.ChannelEventListener;
import com.xiaomi.data.push.rpc.netty.NettyRemotingServer;
import com.xiaomi.data.push.rpc.protocol.RemotingCommand;
import io.netty.channel.Channel;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PushChannelEventListener
implements ChannelEventListener {
    private static final Logger logger = LoggerFactory.getLogger(PushChannelEventListener.class);

    public int clientNum() {
        return AgentContext.ins().map.size();
    }

    public Collection<Channel> clients() {
        return AgentContext.ins().map.values().stream().map(it -> it.getChannel()).collect(Collectors.toList());
    }

    public void sendMessageToAll(NettyRemotingServer server, RemotingCommand command) {
        if (AgentContext.ins().map.size() > 0) {
            AgentContext.ins().map.forEach((k, v) -> {
                try {
                    RemotingCommand res = server.invokeSync(v.getChannel(), command, TimeUnit.SECONDS.toMillis(1L));
                    logger.info("res----->{}", (Object)new String(res.getBody()));
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (RemotingSendRequestException e) {
                    e.printStackTrace();
                }
                catch (RemotingTimeoutException e) {
                    e.printStackTrace();
                }
            });
        }
    }

    public void sendMessageToAll(NettyRemotingServer server, RemotingCommand command, long timeout, InvokeCallback callback) {
        if (AgentContext.ins().map.size() > 0) {
            AgentContext.ins().map.forEach((k, v) -> {
                try {
                    server.invokeAsync(v.getChannel(), command, timeout, callback);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (RemotingSendRequestException e) {
                    e.printStackTrace();
                }
                catch (RemotingTimeoutException e) {
                    e.printStackTrace();
                }
                catch (RemotingTooMuchRequestException e) {
                    e.printStackTrace();
                }
            });
        }
    }

    public void send(Consumer<Channel> consumer) {
        AgentContext.ins().map.forEach((k, v) -> consumer.accept(v.getChannel()));
    }

    @Override
    public void onChannelConnect(String remoteAddr, Channel channel) {
        logger.info("onChannelConnect:{}", (Object)remoteAddr);
        AgentChannel ac = new AgentChannel();
        ac.setChannel(channel);
        ac.setRemoteAddr(remoteAddr);
        AgentContext.ins().map.put(remoteAddr, ac);
    }

    @Override
    public void onChannelClose(String remoteAddr, Channel channel) {
        logger.info("onChannelClose:{}", (Object)remoteAddr);
        AgentContext.ins().map.remove(remoteAddr);
    }

    @Override
    public void onChannelException(String remoteAddr, Channel channel) {
        logger.info("onChannelException:{}", (Object)remoteAddr);
        AgentContext.ins().map.remove(remoteAddr);
        RemotingUtil.closeChannel(channel);
    }

    @Override
    public void onChannelIdle(String remoteAddr, Channel channel) {
    }

    @Override
    public Channel channel(String remoteAddr) {
        return AgentContext.ins().map.get(remoteAddr).getChannel();
    }

    public Channel channel(Predicate<User> predicate) {
        return AgentContext.ins().map.entrySet().stream().map(it -> (AgentChannel)it.getValue()).filter(e -> predicate.test(e.getUser())).findAny().orElse(null);
    }
}

