/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.tea.utils;

import com.aliyun.tea.utils.IOUtils;
import com.aliyun.tea.utils.Validate;
import java.util.HashMap;
import java.util.Map;

public class AttributeMap
implements AutoCloseable {
    private final Map<Key<?>, Object> attributes;

    private AttributeMap(Map<? extends Key<?>, ?> attributes) {
        this.attributes = new HashMap(attributes);
    }

    public <T> boolean containsKey(Key<T> typedKey) {
        return this.attributes.containsKey(typedKey);
    }

    public <T> T get(Key<T> key) {
        Validate.notNull(key, "Key to retrieve must not be null.", new Object[0]);
        return key.convertValue(this.attributes.get(key));
    }

    public <T> AttributeMap put(Key<T> key, T value) {
        Validate.notNull(key, "Key to set must not be null.", new Object[0]);
        this.attributes.put(key, value);
        return this;
    }

    public <T> AttributeMap putIfAbsent(Key<T> key, T value) {
        Validate.notNull(key, "Key to set must not be null.", new Object[0]);
        if (this.attributes.get(key) == null) {
            this.attributes.put(key, value);
        }
        return this;
    }

    public AttributeMap copy() {
        HashMap map = new HashMap();
        for (Map.Entry<Key<?>, Object> entry : this.attributes.entrySet()) {
            entry.getKey().validateValue(entry.getValue());
            map.put(entry.getKey(), entry.getValue());
        }
        return new AttributeMap(map);
    }

    public int size() {
        return this.attributes.size();
    }

    public static AttributeMap empty() {
        return new AttributeMap(new HashMap());
    }

    @Override
    public void close() {
        for (Object value : this.attributes.values()) {
            IOUtils.closeIfCloseable(value);
        }
        this.attributes.clear();
    }

    public static abstract class Key<T> {
        private final Class<?> valueType;

        protected Key(Class<T> valueType) {
            this.valueType = valueType;
        }

        protected Key(UnsafeValueType unsafeValueType) {
            this.valueType = unsafeValueType.valueType;
        }

        final void validateValue(Object value) {
            if (value != null) {
                Validate.isAssignableFrom(this.valueType, value.getClass(), "Invalid option: %s. Required value of type %s, but was %s.", this, this.valueType, value.getClass());
            }
        }

        public final T convertValue(Object value) {
            this.validateValue(value);
            Object result = this.valueType.cast(value);
            return (T)result;
        }

        protected static class UnsafeValueType {
            private final Class<?> valueType;

            public UnsafeValueType(Class<?> valueType) {
                this.valueType = valueType;
            }
        }
    }
}

