/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.ConverterRegistry;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.data.redis.connection.stream.MapRecord;
import org.springframework.data.redis.connection.stream.ObjectRecord;
import org.springframework.data.redis.connection.stream.Record;
import org.springframework.data.redis.connection.stream.StreamRecords;
import org.springframework.data.redis.core.HashMapperProvider;
import org.springframework.data.redis.core.convert.RedisCustomConversions;
import org.springframework.data.redis.hash.HashMapper;
import org.springframework.data.redis.hash.HashObjectReader;
import org.springframework.data.redis.hash.ObjectHashMapper;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

class StreamObjectMapper {
    private static final RedisCustomConversions customConversions = new RedisCustomConversions();
    private static final ConversionService conversionService;
    private final HashMapper<Object, Object, Object> mapper;
    @Nullable
    private final HashMapper<Object, Object, Object> objectHashMapper;

    StreamObjectMapper(HashMapper<?, ?, ?> mapper) {
        Assert.notNull(mapper, (String)"HashMapper must not be null");
        this.mapper = mapper;
        this.objectHashMapper = mapper instanceof ObjectHashMapper ? new BinaryObjectHashMapperAdapter((ObjectHashMapper)mapper) : null;
    }

    static <K, V, HK, HV> MapRecord<K, HK, HV> toMapRecord(HashMapperProvider<HK, HV> provider, Record<K, V> source) {
        if (source instanceof ObjectRecord) {
            ObjectRecord entry = (ObjectRecord)source;
            if (entry.getValue() instanceof Map) {
                return StreamRecords.newRecord().in(source.getStream()).withId(source.getId()).ofMap((Map)entry.getValue());
            }
            return entry.toMapRecord(provider.getHashMapper(entry.getValue().getClass()));
        }
        if (source instanceof MapRecord) {
            return (MapRecord)source;
        }
        return Record.of(provider.getHashMapper(source.getClass()).toHash(source)).withStreamKey(source.getStream());
    }

    static <K, V, HK, HV> ObjectRecord<K, V> toObjectRecord(MapRecord<K, HK, HV> source, HashMapperProvider<HK, HV> provider, Class<V> targetType) {
        return source.toObjectRecord(provider.getHashMapper(targetType));
    }

    @Nullable
    static <K, V, HK, HV> List<ObjectRecord<K, V>> toObjectRecords(@Nullable List<MapRecord<K, HK, HV>> records, HashMapperProvider<HK, HV> hashMapperProvider, Class<V> targetType) {
        if (records == null) {
            return null;
        }
        if (records.isEmpty()) {
            return Collections.emptyList();
        }
        if (records.size() == 1) {
            return Collections.singletonList(StreamObjectMapper.toObjectRecord(records.get(0), hashMapperProvider, targetType));
        }
        ArrayList<ObjectRecord<K, V>> transformed = new ArrayList<ObjectRecord<K, V>>(records.size());
        HashMapper<V, HK, HV> hashMapper = hashMapperProvider.getHashMapper(targetType);
        for (MapRecord<HK, HK, HV> mapRecord : records) {
            transformed.add(mapRecord.toObjectRecord(hashMapper));
        }
        return transformed;
    }

    final <V, HK, HV> HashMapper<V, HK, HV> getHashMapper(final Class<V> targetType) {
        final HashMapper<?, ?, ?> hashMapper = this.doGetHashMapper(conversionService, targetType);
        if (hashMapper instanceof HashObjectReader) {
            return new HashMapper<V, HK, HV>(){

                @Override
                public Map<HK, HV> toHash(V object) {
                    return hashMapper.toHash(object);
                }

                @Override
                public V fromHash(Map<HK, HV> hash) {
                    return ((HashObjectReader)((Object)hashMapper)).fromHash(targetType, hash);
                }
            };
        }
        return hashMapper;
    }

    protected HashMapper<?, ?, ?> doGetHashMapper(ConversionService conversionService, Class<?> targetType) {
        return this.objectHashMapper != null ? this.objectHashMapper : this.mapper;
    }

    boolean isSimpleType(Class<?> targetType) {
        return customConversions.isSimpleType(targetType);
    }

    ConversionService getConversionService() {
        return conversionService;
    }

    static {
        DefaultConversionService cs = new DefaultConversionService();
        customConversions.registerConvertersIn((ConverterRegistry)cs);
        conversionService = cs;
    }

    private static class BinaryObjectHashMapperAdapter
    implements HashMapper<Object, Object, Object>,
    HashObjectReader<Object, Object> {
        private final ObjectHashMapper ohm;

        public BinaryObjectHashMapperAdapter(ObjectHashMapper ohm) {
            this.ohm = ohm;
        }

        @Override
        public Map<Object, Object> toHash(Object object) {
            return this.ohm.toHash(object);
        }

        @Override
        public Object fromHash(Map<Object, Object> hash) {
            return this.ohm.fromHash(BinaryObjectHashMapperAdapter.toMap(hash));
        }

        @Override
        public <R> R fromHash(Class<R> type, Map<Object, Object> hash) {
            return this.ohm.fromHash(type, BinaryObjectHashMapperAdapter.toMap(hash));
        }

        private static Map<byte[], byte[]> toMap(Map<Object, Object> hash) {
            LinkedHashMap<byte[], byte[]> target = new LinkedHashMap<byte[], byte[]>(hash.size());
            for (Map.Entry<Object, Object> entry : hash.entrySet()) {
                target.put(BinaryObjectHashMapperAdapter.toBytes(entry.getKey()), BinaryObjectHashMapperAdapter.toBytes(entry.getValue()));
            }
            return target;
        }

        @Nullable
        private static byte[] toBytes(Object value) {
            return value instanceof byte[] ? (byte[])value : (byte[])conversionService.convert(value, byte[].class);
        }
    }
}

