/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core.convert;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.core.convert.Bucket;
import org.springframework.data.redis.core.convert.IndexedData;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class RedisData {
    private final Bucket bucket;
    private final Set<IndexedData> indexedData;
    @Nullable
    private String keyspace;
    @Nullable
    private String id;
    @Nullable
    private Long timeToLive;

    public RedisData() {
        this(Collections.emptyMap());
    }

    public RedisData(Map<byte[], byte[]> raw) {
        this(Bucket.newBucketFromRawMap(raw));
    }

    public RedisData(Bucket bucket) {
        Assert.notNull((Object)bucket, (String)"Bucket must not be null!");
        this.bucket = bucket;
        this.indexedData = new HashSet<IndexedData>();
    }

    public void setId(@Nullable String id) {
        this.id = id;
    }

    @Nullable
    public String getId() {
        return this.id;
    }

    @Nullable
    public Long getTimeToLive() {
        return this.timeToLive;
    }

    public void addIndexedData(IndexedData index) {
        Assert.notNull((Object)index, (String)"IndexedData to add must not be null!");
        this.indexedData.add(index);
    }

    public void addIndexedData(Collection<IndexedData> indexes) {
        Assert.notNull(indexes, (String)"IndexedData to add must not be null!");
        this.indexedData.addAll(indexes);
    }

    public Set<IndexedData> getIndexedData() {
        return Collections.unmodifiableSet(this.indexedData);
    }

    @Nullable
    public String getKeyspace() {
        return this.keyspace;
    }

    public void setKeyspace(@Nullable String keyspace) {
        this.keyspace = keyspace;
    }

    public Bucket getBucket() {
        return this.bucket;
    }

    public void setTimeToLive(Long timeToLive) {
        this.timeToLive = timeToLive;
    }

    public void setTimeToLive(Long timeToLive, TimeUnit timeUnit) {
        Assert.notNull((Object)timeToLive, (String)"TimeToLive must not be null when used with TimeUnit!");
        Assert.notNull((Object)timeToLive, (String)"TimeUnit must not be null!");
        this.setTimeToLive(TimeUnit.SECONDS.convert(timeToLive, timeUnit));
    }

    public String toString() {
        return "RedisDataObject [key=" + this.keyspace + ":" + this.id + ", hash=" + this.bucket + "]";
    }
}

