/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.serializer;

import java.nio.ByteBuffer;
import org.springframework.data.redis.serializer.RedisElementWriter;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.lang.Nullable;

class DefaultRedisElementWriter<T>
implements RedisElementWriter<T> {
    @Nullable
    private final RedisSerializer<T> serializer;

    DefaultRedisElementWriter(RedisSerializer<T> serializer) {
        this.serializer = serializer;
    }

    @Override
    public ByteBuffer write(T value) {
        if (this.serializer != null && (value == null || this.serializer.canSerialize(value.getClass()))) {
            return ByteBuffer.wrap(this.serializer.serialize(value));
        }
        if (value instanceof byte[]) {
            return ByteBuffer.wrap((byte[])value);
        }
        if (value instanceof ByteBuffer) {
            return (ByteBuffer)value;
        }
        throw new IllegalStateException(String.format("Cannot serialize value of type %s without a serializer", value.getClass()));
    }
}

