/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.app.redis;

import com.alibaba.nacos.api.config.annotation.NacosValue;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisPooled;
import redis.clients.jedis.bloom.BFInsertParams;
import redis.clients.jedis.bloom.BFReserveParams;
import redis.clients.jedis.commands.JedisCommands;
import redis.clients.jedis.params.ScanParams;
import redis.clients.jedis.params.SetParams;
import redis.clients.jedis.resps.ScanResult;

@Component
public class RedisService {
    private static final Logger log = LoggerFactory.getLogger(RedisService.class);
    @NacosValue(value="${spring.redis.cluster}")
    private String cluster;
    @NacosValue(value="${spring.redis.cluster.nodes}")
    private String clusterNodes;
    @NacosValue(value="${spring.redis.timeout.connection}")
    private int timeout;
    @NacosValue(value="${spring.redis.jedis.pool.max-active}")
    private int maxActive;
    @NacosValue(value="${spring.redis.pool.max-idle}")
    private int maxIdle;
    @NacosValue(value="${spring.redis.pool.max-wait}")
    private long maxWaitMillis;
    @NacosValue(value="${spring.redis.password}")
    private String pwd;
    @NacosValue(value="${spring.redis.max-attempts}")
    private int maxAttempts;
    private BFInsertParams param = new BFInsertParams();
    private long ttlSeconds = 5L;
    private long waitTimeOut = 30000L;
    private static final int SCAN_PARAM_BATCH = 100;
    private static final ScanParams SCAN_PARAMS = new ScanParams().count(Integer.valueOf(100));
    private SetParams disLockParam = SetParams.setParams().ex(this.ttlSeconds).nx();
    private JedisCommands jedis;
    private JedisPooled jedisPooled;
    private JedisCluster jedisCluster;
    private static final BFReserveParams NON_SCALING = BFReserveParams.reserveParams().nonScaling();

    @PostConstruct
    public void init() {
        this.param.noCreate();
        if ("true".equals(this.cluster)) {
            String[] serverArray = this.clusterNodes.split(",");
            HashSet<HostAndPort> nodes = new HashSet<HostAndPort>();
            for (String ipPort : serverArray) {
                String[] ipPortPair = ipPort.split(":");
                nodes.add(new HostAndPort(ipPortPair[0].trim(), Integer.valueOf(ipPortPair[1].trim()).intValue()));
            }
            this.jedisCluster = StringUtils.isEmpty((CharSequence)this.pwd) ? new JedisCluster(nodes, this.timeout, this.timeout, this.maxAttempts, this.getGenericObjectPoolConfig()) : new JedisCluster(nodes, this.timeout, this.timeout, this.maxAttempts, this.pwd, this.getGenericObjectPoolConfig());
            this.jedis = this.jedisCluster;
        } else {
            String[] hp = this.clusterNodes.split(":");
            this.jedisPooled = StringUtils.isEmpty((CharSequence)this.pwd) ? new JedisPooled(this.getGenericObjectPoolConfig(), hp[0].trim(), Integer.valueOf(hp[1]).intValue(), this.timeout) : new JedisPooled(this.getGenericObjectPoolConfig(), hp[0].trim(), Integer.valueOf(hp[1]).intValue(), this.timeout, this.pwd);
            this.jedis = this.jedisPooled;
        }
    }

    private GenericObjectPoolConfig getGenericObjectPoolConfig() {
        GenericObjectPoolConfig genericObjectPoolConfig = new GenericObjectPoolConfig();
        genericObjectPoolConfig.setMaxTotal(this.maxActive);
        genericObjectPoolConfig.setMaxIdle(this.maxIdle);
        genericObjectPoolConfig.setMaxWaitMillis(this.maxWaitMillis);
        genericObjectPoolConfig.setTimeBetweenEvictionRunsMillis(5000L);
        genericObjectPoolConfig.setMinEvictableIdleTimeMillis(15L);
        genericObjectPoolConfig.setTestWhileIdle(true);
        return genericObjectPoolConfig;
    }

    public Boolean sismember(String key, String member) {
        try {
            return this.jedis.sismember(key, member);
        }
        catch (Exception e) {
            log.error("redis sismember error key:" + key + " member:" + member, (Throwable)e);
            return null;
        }
    }

    public Long sadd(String key, String ... members) {
        try {
            return this.jedis.sadd(key, members);
        }
        catch (Exception e) {
            log.error("redis sadd error key:" + key, (Throwable)e);
            return 0L;
        }
    }

    public Long setNx(String key, String value) {
        try {
            return this.jedis.setnx(key, value);
        }
        catch (Exception e) {
            log.error("redis sadd error key:" + key, (Throwable)e);
            return 0L;
        }
    }

    public boolean getDisLock(String key) {
        long startTime = System.currentTimeMillis();
        try {
            do {
                if ("OK".equals(this.jedis.set(key, "1", this.disLockParam))) {
                    return true;
                }
                Thread.sleep(100L);
            } while (System.currentTimeMillis() - startTime <= this.waitTimeOut);
            log.warn("\u7b49\u5f85\u5206\u5e03\u5f0f\u9501\u8d85\u8fc730\u79d2...");
            return true;
        }
        catch (Exception e) {
            log.error("redis getDisLock error key:" + key, (Throwable)e);
            return false;
        }
    }

    public Boolean setbit(String key, long offset, boolean value) {
        try {
            return this.jedis.setbit(key, offset, value);
        }
        catch (Exception e) {
            log.error("redis setbit error key:" + key, (Throwable)e);
            return null;
        }
    }

    public Boolean getbit(String key, long offset) {
        try {
            return this.jedis.getbit(key, offset);
        }
        catch (Exception e) {
            log.error("redis getbit error key:" + key, (Throwable)e);
            return null;
        }
    }

    public Boolean exists(String key) {
        try {
            return this.jedis.exists(key);
        }
        catch (Exception e) {
            log.error("redis exists error key:" + key, (Throwable)e);
            return null;
        }
    }

    public long expire(String key, int seconds) {
        try {
            return this.jedis.expire(key, (long)seconds);
        }
        catch (Exception e) {
            log.error("redis expire error key:" + key, (Throwable)e);
            return 0L;
        }
    }

    public long ttl(String key) {
        try {
            return this.jedis.ttl(key);
        }
        catch (Exception e) {
            log.error("redis expire error key:" + key, (Throwable)e);
            return 0L;
        }
    }

    public String get(String key) {
        try {
            return this.jedis.get(key);
        }
        catch (Exception e) {
            log.error("redis sadd error key:" + key, (Throwable)e);
            return null;
        }
    }

    public String set(String key, String value) {
        try {
            return this.jedis.set(key, value);
        }
        catch (Exception e) {
            log.error("redis set error key:" + key, (Throwable)e);
            return null;
        }
    }

    public String set(String key, String value, long ttl) {
        try {
            String set = this.jedis.set(key, value);
            if ("OK".equals(set)) {
                this.jedis.expire(key, ttl);
            }
            return set;
        }
        catch (Exception e) {
            log.error("redis set error key:" + key, (Throwable)e);
            return null;
        }
    }

    public Long del(String key) {
        try {
            return this.jedis.del(key);
        }
        catch (Exception e) {
            log.error("redis del error key:" + key, (Throwable)e);
            return null;
        }
    }

    public String hget(String key, String field) {
        try {
            return this.jedis.hget(key, field);
        }
        catch (Exception e) {
            log.error("redis hget error key: " + key + " field: " + field, (Throwable)e);
            return null;
        }
    }

    public Long hset(String key, String field, String value) {
        try {
            return this.jedis.hset(key, field, value);
        }
        catch (Exception e) {
            log.error("redis hset error key: " + key + " field: " + field + " value: " + value, (Throwable)e);
            return null;
        }
    }

    public Map<String, String> hgetAll(String key) {
        try {
            ScanResult scanResult;
            HashMap<String, String> result = new HashMap<String, String>();
            String cursor = "0";
            do {
                scanResult = this.jedis.hscan(key, cursor, SCAN_PARAMS);
                List entries = scanResult.getResult();
                for (Map.Entry entry : entries) {
                    result.put((String)entry.getKey(), (String)entry.getValue());
                }
            } while (!"0".equals(cursor = scanResult.getCursor()));
            return result;
        }
        catch (Exception e) {
            log.error("redis hgetAll error key: " + key, (Throwable)e);
            return null;
        }
    }

    public Long hdel(String key, String ... fields) {
        try {
            return this.jedis.hdel(key, fields);
        }
        catch (Exception e) {
            log.error("redis hdel error key: " + key, (Throwable)e);
            return null;
        }
    }

    public List<Boolean> bfMAdd(String key, String ... items) {
        try {
            if ("true".equals(this.cluster)) {
                return this.jedisCluster.bfMAdd(key, items);
            }
            return this.jedisPooled.bfMAdd(key, items);
        }
        catch (Exception e) {
            log.error("redis bfMAdd error key:" + key, (Throwable)e);
            return null;
        }
    }

    public Boolean bfExist(String key, String item) {
        try {
            if ("true".equals(this.cluster)) {
                return this.jedisCluster.bfExists(key, item);
            }
            return this.jedisPooled.bfExists(key, item);
        }
        catch (Exception e) {
            log.error("redis bfExists error key:" + key, (Throwable)e);
            return null;
        }
    }

    public List<Boolean> bfMExist(String key, String ... item) {
        try {
            if ("true".equals(this.cluster)) {
                return this.jedisCluster.bfMExists(key, item);
            }
            return this.jedisPooled.bfMExists(key, item);
        }
        catch (Exception e) {
            log.error("redis bfExists error key:" + key, (Throwable)e);
            return null;
        }
    }

    public String bfReserve(String key, double errorRate, long capacity, boolean scaling) {
        try {
            if ("true".equals(this.cluster)) {
                if (scaling) {
                    return this.jedisCluster.bfReserve(key, errorRate, capacity);
                }
                return this.jedisCluster.bfReserve(key, errorRate, capacity, NON_SCALING);
            }
            if (scaling) {
                return this.jedisPooled.bfReserve(key, errorRate, capacity);
            }
            return this.jedisPooled.bfReserve(key, errorRate, capacity, NON_SCALING);
        }
        catch (Exception e) {
            log.error("redis bfReserve error key:" + key, (Throwable)e);
            return null;
        }
    }

    public List<Boolean> bfInsert(String key, String ... items) {
        try {
            if ("true".equals(this.cluster)) {
                return this.jedisCluster.bfInsert(key, this.param, items);
            }
            return this.jedisPooled.bfInsert(key, this.param, items);
        }
        catch (Exception e) {
            log.error("redis bfReserve error key:" + key, (Throwable)e);
            return null;
        }
    }

    public Map<String, Object> bfInfo(String key) {
        try {
            if ("true".equals(this.cluster)) {
                return this.jedisCluster.bfInfo(key);
            }
            return this.jedisPooled.bfInfo(key);
        }
        catch (Exception e) {
            log.error("redis bfReserve error key:" + key, (Throwable)e);
            return null;
        }
    }
}

