/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.prometheus.agent.prometheusClient;

import com.alibaba.nacos.api.config.annotation.NacosValue;
import com.aliyun.arms20190808.models.CreateEnvCustomJobResponse;
import com.aliyun.arms20190808.models.CreateEnvironmentResponse;
import com.aliyun.arms20190808.models.DeleteEnvCustomJobResponse;
import com.aliyun.arms20190808.models.ListEnvCustomJobsResponse;
import com.aliyun.arms20190808.models.ListEnvCustomJobsResponseBody;
import com.aliyun.arms20190808.models.ListEnvironmentsResponse;
import com.aliyun.arms20190808.models.UpdateEnvCustomJobResponse;
import com.google.common.base.Stopwatch;
import com.google.gson.Gson;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.prometheus.agent.client.Client;
import org.apache.ozhera.prometheus.agent.enums.ScrapeJobStatusEnum;
import org.apache.ozhera.prometheus.agent.operators.ali.AliPrometheusOperator;
import org.apache.ozhera.prometheus.agent.param.prometheus.ali.Scrape_configs;
import org.apache.ozhera.prometheus.agent.param.scrapeConfig.ScrapeConfigDetail;
import org.apache.ozhera.prometheus.agent.service.prometheus.ScrapeJobService;
import org.apache.ozhera.prometheus.agent.util.CommitPoolUtil;
import org.apache.ozhera.prometheus.agent.util.YamlUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class PrometheusAliClient
implements Client {
    private static final Logger log = LoggerFactory.getLogger(PrometheusAliClient.class);
    @NacosValue(value="${job.prometheus.enabled}", autoRefreshed=true)
    private String enabled;
    @NacosValue(value="${job.prometheus.healthAddr}", autoRefreshed=true)
    private String healthAddr;
    @Autowired
    ScrapeJobService scrapeJobService;
    @Autowired
    AliPrometheusOperator aliOperator;
    private CopyOnWriteArrayList<org.apache.ozhera.prometheus.agent.param.prometheus.Scrape_configs> localConfigs = new CopyOnWriteArrayList();
    private CopyOnWriteArrayList<org.apache.ozhera.prometheus.agent.param.prometheus.Scrape_configs> needDeleteConfigs = new CopyOnWriteArrayList();
    public static final Gson gson = new Gson();
    private boolean firstInitSign = false;
    private String environmentId = "";
    private ReentrantLock lock = new ReentrantLock();

    @PostConstruct
    public void init() {
        log.info("PrometheusAliClient begin init!");
        if (this.enabled.equals("true")) {
            String aliPrometheusEnvironment = this.getAliPrometheusEnvironment();
            if (StringUtils.isBlank((CharSequence)aliPrometheusEnvironment)) {
                log.error("PrometheusAliClient request environment fail !!!");
                System.exit(-2);
            }
            this.environmentId = aliPrometheusEnvironment;
            this.scrapeJobService.setPendingScrapeConfig();
            this.GetLocalConfigs();
            this.CompareAndReload();
        } else {
            log.info("PrometheusAliClient not init");
        }
    }

    @Override
    public void GetLocalConfigs() {
        CommitPoolUtil.PROMETHEUS_LOCAL_CONFIG_POOL.scheduleWithFixedDelay(() -> {
            Stopwatch sw = Stopwatch.createStarted();
            log.info("PrometheusAliClient start GetLocalConfigs");
            try {
                List allScrapeConfigList = this.scrapeJobService.getAllCloudScrapeConfigList(ScrapeJobStatusEnum.ALL.getDesc());
                this.localConfigs.clear();
                this.needDeleteConfigs.clear();
                allScrapeConfigList.forEach(item -> {
                    ScrapeConfigDetail detail = (ScrapeConfigDetail)gson.fromJson(item.getBody(), ScrapeConfigDetail.class);
                    org.apache.ozhera.prometheus.agent.param.prometheus.Scrape_configs sc = new org.apache.ozhera.prometheus.agent.param.prometheus.Scrape_configs();
                    sc.setRelabel_configs(detail.getRelabel_configs());
                    sc.setMetric_relabel_configs(detail.getMetric_relabel_configs());
                    sc.setStatic_configs(detail.getStatic_configs());
                    sc.setJob_name(detail.getJob_name());
                    sc.setParams(detail.getParams());
                    sc.setMetrics_path(detail.getMetrics_path());
                    sc.setHonor_labels(detail.isHonor_labels());
                    sc.setHttp_sd_configs(detail.getHttp_sd_configs());
                    sc.setScheme(detail.getScheme());
                    sc.setScrape_interval(detail.getScrape_interval());
                    sc.setScrape_timeout(detail.getScrape_timeout());
                    if (item.getStatus().equals(ScrapeJobStatusEnum.DELETE.getDesc())) {
                        this.needDeleteConfigs.add(sc);
                    } else {
                        this.localConfigs.add(sc);
                    }
                });
                log.info("PrometheusAliClient GetLocalConfigs done ,and jobNum :{}", (Object)this.localConfigs.size());
                this.firstInitSign = true;
            }
            catch (Exception e) {
                log.error("PrometheusAliClient GetLocalConfigs error :{}", (Object)e.getMessage());
            }
            finally {
                log.info("PrometheusAliClient end GetLocalConfigs cost: {}ms", (Object)sw.elapsed(TimeUnit.MILLISECONDS));
            }
        }, 0L, 30L, TimeUnit.SECONDS);
    }

    @Override
    public void CompareAndReload() {
        CommitPoolUtil.PROMETHEUS_COMPARE_RELOAD_POOL.scheduleWithFixedDelay(() -> {
            Stopwatch sw = Stopwatch.createStarted();
            try {
                if (this.localConfigs.isEmpty()) {
                    log.info("PrometheusAliClient scrapeJob no need to reload");
                    return;
                }
                if (!this.firstInitSign) {
                    log.info("PrometheusAliClient CompareAndReload waiting..");
                    return;
                }
                log.info("PrometheusAliClient start CompareAndReload");
                this.createOrUpdateAliPrometheusJob();
                log.info("PrometheusAliClient end CompareAndReload cost:{}ms", (Object)sw.elapsed(TimeUnit.MILLISECONDS));
            }
            catch (Exception e) {
                log.error("PrometheusClient CompareAndReload error :{}", (Object)e.getMessage());
            }
            finally {
                log.info("PrometheusAliClient end CompareAndReload cost: {}ms", (Object)sw.elapsed(TimeUnit.MILLISECONDS));
            }
        }, 0L, 30L, TimeUnit.SECONDS);
    }

    private String getAliPrometheusEnvironment() {
        log.info("PrometheusAliClient.getAliPrometheusEnvironment begin,operator is :{}", (Object)this.aliOperator.printTriplicities());
        try {
            this.aliOperator.describeEnvironment();
            ListEnvironmentsResponse listEnvironmentsResponse = this.aliOperator.ListEnvironments();
            if (listEnvironmentsResponse == null || !Objects.equals(listEnvironmentsResponse.getStatusCode(), AliPrometheusOperator.SUCCESS_CODE)) {
                log.error("PrometheusAliClient.getAliPrometheusEnvironment.ListEnvironments Not successful!");
                return null;
            }
            AtomicReference<String> environmentId = new AtomicReference<String>();
            List environments = listEnvironmentsResponse.getBody().getData().getEnvironments();
            environments.forEach(env -> {
                if (env.environmentName.equals(AliPrometheusOperator.ALI_ENVIRONMENT_NAME)) {
                    environmentId.set(env.environmentId);
                }
            });
            if (environmentId.get() != null) {
                return (String)environmentId.get();
            }
            log.info("PrometheusAliClient.getAliPrometheusEnvironment not found and begin create environment");
            CreateEnvironmentResponse createEnvironmentResponse = this.aliOperator.CreateEnvironment();
            if (createEnvironmentResponse == null || !Objects.equals(createEnvironmentResponse.getStatusCode(), AliPrometheusOperator.SUCCESS_CODE)) {
                log.error("PrometheusAliClient.createOrUpdateAliPrometheusEnvironment.createEnvironmentResponse Not successful!");
                return null;
            }
            environmentId.set(createEnvironmentResponse.getBody().getData());
            return (String)environmentId.get();
        }
        catch (Exception e) {
            log.error("PrometheusAliClient.getAliPrometheusEnvironment error :{}", (Object)e.getMessage());
            return null;
        }
    }

    private void createOrUpdateAliPrometheusJob() {
        log.info("PrometheusAliClient.createOrUpdateAliPrometheusJob begin,operator is :{}", (Object)this.aliOperator.printTriplicities());
        this.lock.lock();
        try {
            this.needDeleteConfigs.forEach(deleteJob -> {
                DeleteEnvCustomJobResponse deleteEnvCustomJobResponse = this.aliOperator.deleteEnvCustomJob(this.environmentId, deleteJob.getJob_name());
                if (deleteEnvCustomJobResponse == null || !Objects.equals(deleteEnvCustomJobResponse.getStatusCode(), AliPrometheusOperator.SUCCESS_CODE)) {
                    log.error("PrometheusAliClient.createOrUpdateAliPrometheusJobV2.deleteEnvCustomJob Not successful,jobName:{}", (Object)deleteJob.getJob_name());
                } else {
                    this.scrapeJobService.updateAllScrapeConfigDeleteToDone(deleteJob);
                }
            });
            ListEnvCustomJobsResponse listEnvCustomJobsResponse = this.aliOperator.ListEnvCustomJobs(this.environmentId);
            if (listEnvCustomJobsResponse == null || !Objects.equals(listEnvCustomJobsResponse.getStatusCode(), AliPrometheusOperator.SUCCESS_CODE)) {
                log.error("PrometheusAliClient.createOrUpdateAliPrometheusJob.ListEnvCustomJobs Not successful!");
                return;
            }
            List remoteAliJobs = listEnvCustomJobsResponse.getBody().getData();
            if (remoteAliJobs.isEmpty()) {
                log.info("PrometheusAliClient.createOrUpdateAliPrometheusJob.remoteAliJobs is empty and begin create");
                this.innerCreateOrUpdateJob(true, null, remoteAliJobs);
                return;
            }
            if (this.localConfigs.isEmpty()) {
                log.info("PrometheusAliClient.createOrUpdateAliPrometheusJob.localConfigs is empty");
                return;
            }
            this.localConfigs.forEach(job -> this.innerCreateOrUpdateJob(false, job.getJob_name(), remoteAliJobs));
        }
        catch (Exception ex) {
            log.info("PrometheusAliClient.createOrUpdateAliPrometheusJob error :{}", (Object)ex.getMessage());
        }
        finally {
            this.lock.unlock();
        }
    }

    private void createOrUpdateAliPrometheusJobV2() {
        this.lock.lock();
        log.info("PrometheusAliClient.createOrUpdateAliPrometheusJob begin,operator is :{}", (Object)this.aliOperator.printTriplicities());
        try {
            ListEnvCustomJobsResponse listEnvCustomJobsResponse = this.aliOperator.ListEnvCustomJobs(this.environmentId);
            if (listEnvCustomJobsResponse == null || !Objects.equals(listEnvCustomJobsResponse.getStatusCode(), AliPrometheusOperator.SUCCESS_CODE)) {
                log.error("PrometheusAliClient.createOrUpdateAliPrometheusJob.ListEnvCustomJobs Not successful!");
                return;
            }
            List remoteAliJobs = listEnvCustomJobsResponse.getBody().getData();
            if (this.localConfigs.isEmpty()) {
                log.info("PrometheusAliClient.createOrUpdateAliPrometheusJob.localConfigs is empty");
                return;
            }
            remoteAliJobs.forEach(remoteJob -> {
                DeleteEnvCustomJobResponse deleteEnvCustomJobResponse = this.aliOperator.deleteEnvCustomJob(this.environmentId, remoteJob.getCustomJobName());
                if (deleteEnvCustomJobResponse == null || !Objects.equals(deleteEnvCustomJobResponse.getStatusCode(), AliPrometheusOperator.SUCCESS_CODE)) {
                    log.error("PrometheusAliClient.createOrUpdateAliPrometheusJobV2.deleteEnvCustomJob Not successful,jobName:{}", (Object)remoteJob.getCustomJobName());
                }
            });
            this.localConfigs.forEach(config -> {
                String initJobName = config.getJob_name();
                Scrape_configs aliConfig = new Scrape_configs();
                CopyOnWriteArrayList<org.apache.ozhera.prometheus.agent.param.prometheus.Scrape_configs> confList = new CopyOnWriteArrayList<org.apache.ozhera.prometheus.agent.param.prometheus.Scrape_configs>();
                confList.add((org.apache.ozhera.prometheus.agent.param.prometheus.Scrape_configs)config);
                aliConfig.setScrape_configs(confList);
                String promYml = YamlUtil.toYaml((Object)aliConfig);
                CreateEnvCustomJobResponse createEnvCustomJobResponse = this.aliOperator.CreateEnvCustomJob(this.environmentId, initJobName, promYml);
                if (createEnvCustomJobResponse == null || !Objects.equals(createEnvCustomJobResponse.getStatusCode(), AliPrometheusOperator.SUCCESS_CODE)) {
                    log.error("PrometheusAliClient.createOrUpdateAliPrometheusJobV2.CreateEnvCustomJob Not successful,jobName:{}", (Object)initJobName);
                }
            });
        }
        catch (Exception ex) {
            log.error("PrometheusAliClient.createOrUpdateAliPrometheusJob error :{}", (Throwable)ex);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void innerCreateOrUpdateJob(boolean isFirst, String jobName, List<ListEnvCustomJobsResponseBody.ListEnvCustomJobsResponseBodyData> remoteAliJobs) {
        if (isFirst) {
            log.info("PrometheusAliClient.innerCreateOrUpdateJob first init");
            this.localConfigs.forEach(config -> {
                String initJobName = config.getJob_name();
                Scrape_configs aliConfig = new Scrape_configs();
                CopyOnWriteArrayList<org.apache.ozhera.prometheus.agent.param.prometheus.Scrape_configs> confList = new CopyOnWriteArrayList<org.apache.ozhera.prometheus.agent.param.prometheus.Scrape_configs>();
                confList.add((org.apache.ozhera.prometheus.agent.param.prometheus.Scrape_configs)config);
                aliConfig.setScrape_configs(confList);
                String promYml = YamlUtil.toYaml((Object)aliConfig);
                CreateEnvCustomJobResponse createEnvCustomJobResponse = this.aliOperator.CreateEnvCustomJob(this.environmentId, initJobName, promYml);
                if (createEnvCustomJobResponse == null || !Objects.equals(createEnvCustomJobResponse.getStatusCode(), AliPrometheusOperator.SUCCESS_CODE)) {
                    log.error("PrometheusAliClient.innerCreateOrUpdateJob.CreateEnvCustomJob Not successful,jobName:{}", (Object)initJobName);
                }
            });
        } else {
            AtomicBoolean isFindInRemote = new AtomicBoolean(false);
            remoteAliJobs.forEach(remoteConfig -> {
                if (remoteConfig.getCustomJobName().equals(jobName)) {
                    org.apache.ozhera.prometheus.agent.param.prometheus.Scrape_configs localConfigByJobName = this.getLocalConfigByJobName(jobName);
                    Scrape_configs aliConfig = new Scrape_configs();
                    CopyOnWriteArrayList<org.apache.ozhera.prometheus.agent.param.prometheus.Scrape_configs> confList = new CopyOnWriteArrayList<org.apache.ozhera.prometheus.agent.param.prometheus.Scrape_configs>();
                    confList.add(localConfigByJobName);
                    aliConfig.setScrape_configs(confList);
                    String promYml = YamlUtil.toYaml((Object)aliConfig);
                    UpdateEnvCustomJobResponse updateEnvCustomJobResponse = this.aliOperator.updateEnvCustomJob(this.environmentId, jobName, promYml, "run");
                    if (updateEnvCustomJobResponse == null || !Objects.equals(updateEnvCustomJobResponse.getStatusCode(), AliPrometheusOperator.SUCCESS_CODE)) {
                        log.error("PrometheusAliClient.innerCreateOrUpdateJob.UpdateEnvCustomJob Not successful,jobName:{}", (Object)jobName);
                    }
                    isFindInRemote.set(true);
                }
            });
            if (!isFindInRemote.get()) {
                org.apache.ozhera.prometheus.agent.param.prometheus.Scrape_configs localConfigByJobName = this.getLocalConfigByJobName(jobName);
                Scrape_configs aliConfig = new Scrape_configs();
                CopyOnWriteArrayList<org.apache.ozhera.prometheus.agent.param.prometheus.Scrape_configs> confList = new CopyOnWriteArrayList<org.apache.ozhera.prometheus.agent.param.prometheus.Scrape_configs>();
                confList.add(localConfigByJobName);
                aliConfig.setScrape_configs(confList);
                String promYml = YamlUtil.toYaml((Object)aliConfig);
                CreateEnvCustomJobResponse createEnvCustomJobResponse = this.aliOperator.CreateEnvCustomJob(this.environmentId, jobName, promYml);
                if (createEnvCustomJobResponse == null || !Objects.equals(createEnvCustomJobResponse.getStatusCode(), AliPrometheusOperator.SUCCESS_CODE)) {
                    log.error("PrometheusAliClient.innerCreateOrUpdateJob.CreateEnvCustomJob Not successful,jobName:{}", (Object)jobName);
                }
            }
        }
    }

    private org.apache.ozhera.prometheus.agent.param.prometheus.Scrape_configs getLocalConfigByJobName(String jobName) {
        AtomicReference targetConfig = new AtomicReference();
        this.localConfigs.forEach(config -> {
            if (config.getJob_name().equals(jobName)) {
                targetConfig.set(config);
            }
        });
        return (org.apache.ozhera.prometheus.agent.param.prometheus.Scrape_configs)targetConfig.get();
    }
}

