/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.generator;

import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.Version;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.generator.InjectionConfig;
import com.baomidou.mybatisplus.generator.config.DataSourceConfig;
import com.baomidou.mybatisplus.generator.config.GlobalConfig;
import com.baomidou.mybatisplus.generator.config.PackageConfig;
import com.baomidou.mybatisplus.generator.config.StrategyConfig;
import com.baomidou.mybatisplus.generator.config.TemplateConfig;
import com.baomidou.mybatisplus.generator.config.builder.ConfigBuilder;
import com.baomidou.mybatisplus.generator.config.po.TableField;
import com.baomidou.mybatisplus.generator.config.po.TableInfo;
import com.baomidou.mybatisplus.generator.engine.AbstractTemplateEngine;
import com.baomidou.mybatisplus.generator.engine.VelocityTemplateEngine;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoGenerator {
    private static final Logger logger = LoggerFactory.getLogger(AutoGenerator.class);
    protected ConfigBuilder config;
    protected InjectionConfig injectionConfig;
    private DataSourceConfig dataSource;
    private StrategyConfig strategy;
    private PackageConfig packageInfo;
    private TemplateConfig template;
    private GlobalConfig globalConfig;
    private AbstractTemplateEngine templateEngine;

    public void execute() {
        logger.debug("==========================\u51c6\u5907\u751f\u6210\u6587\u4ef6...==========================");
        if (null == this.config) {
            this.config = new ConfigBuilder(this.packageInfo, this.dataSource, this.strategy, this.template, this.globalConfig);
            if (null != this.injectionConfig) {
                this.injectionConfig.setConfig(this.config);
            }
        }
        if (null == this.templateEngine) {
            this.templateEngine = new VelocityTemplateEngine();
        }
        this.templateEngine.init(this.pretreatmentConfigBuilder(this.config)).mkdirs().batchOutput().open();
        logger.debug("==========================\u6587\u4ef6\u751f\u6210\u5b8c\u6210\uff01\uff01\uff01==========================");
    }

    protected List<TableInfo> getAllTableInfoList(ConfigBuilder config) {
        return config.getTableInfoList();
    }

    protected ConfigBuilder pretreatmentConfigBuilder(ConfigBuilder config) {
        if (null != this.injectionConfig) {
            this.injectionConfig.initMap();
            config.setInjectionConfig(this.injectionConfig);
        }
        List<TableInfo> tableList = this.getAllTableInfoList(config);
        for (TableInfo tableInfo : tableList) {
            if (config.getGlobalConfig().isActiveRecord()) {
                tableInfo.setImportPackages(Model.class.getCanonicalName());
            }
            if (tableInfo.isConvert()) {
                tableInfo.setImportPackages(TableName.class.getCanonicalName());
            }
            if (config.getStrategyConfig().getLogicDeleteFieldName() != null && tableInfo.isLogicDelete(config.getStrategyConfig().getLogicDeleteFieldName())) {
                tableInfo.setImportPackages(TableLogic.class.getCanonicalName());
            }
            if (StringUtils.isNotBlank((CharSequence)config.getStrategyConfig().getVersionFieldName())) {
                tableInfo.setImportPackages(Version.class.getCanonicalName());
            }
            boolean importSerializable = true;
            if (StringUtils.isNotBlank((CharSequence)config.getStrategyConfig().getSuperEntityClass())) {
                tableInfo.setImportPackages(config.getStrategyConfig().getSuperEntityClass());
                importSerializable = false;
            }
            if (config.getGlobalConfig().isActiveRecord()) {
                importSerializable = true;
            }
            if (importSerializable) {
                tableInfo.setImportPackages(Serializable.class.getCanonicalName());
            }
            if (!config.getStrategyConfig().isEntityBooleanColumnRemoveIsPrefix() || !CollectionUtils.isNotEmpty(tableInfo.getFields())) continue;
            List<TableField> tableFields = tableInfo.getFields().stream().filter(field -> "boolean".equalsIgnoreCase(field.getPropertyType())).filter(field -> field.getPropertyName().startsWith("is")).collect(Collectors.toList());
            tableFields.forEach(field -> {
                if (field.isKeyFlag()) {
                    tableInfo.setImportPackages(TableId.class.getCanonicalName());
                } else {
                    tableInfo.setImportPackages(com.baomidou.mybatisplus.annotation.TableField.class.getCanonicalName());
                }
                field.setConvert(true);
                field.setPropertyName(StringUtils.removePrefixAfterPrefixToLower((String)field.getPropertyName(), (int)2));
            });
        }
        return config.setTableInfoList(tableList);
    }

    public InjectionConfig getCfg() {
        return this.injectionConfig;
    }

    public AutoGenerator setCfg(InjectionConfig injectionConfig) {
        this.injectionConfig = injectionConfig;
        return this;
    }

    public ConfigBuilder getConfig() {
        return this.config;
    }

    public DataSourceConfig getDataSource() {
        return this.dataSource;
    }

    public StrategyConfig getStrategy() {
        return this.strategy;
    }

    public PackageConfig getPackageInfo() {
        return this.packageInfo;
    }

    public TemplateConfig getTemplate() {
        return this.template;
    }

    public GlobalConfig getGlobalConfig() {
        return this.globalConfig;
    }

    public AbstractTemplateEngine getTemplateEngine() {
        return this.templateEngine;
    }

    public AutoGenerator setConfig(ConfigBuilder config) {
        this.config = config;
        return this;
    }

    public AutoGenerator setDataSource(DataSourceConfig dataSource) {
        this.dataSource = dataSource;
        return this;
    }

    public AutoGenerator setStrategy(StrategyConfig strategy) {
        this.strategy = strategy;
        return this;
    }

    public AutoGenerator setPackageInfo(PackageConfig packageInfo) {
        this.packageInfo = packageInfo;
        return this;
    }

    public AutoGenerator setTemplate(TemplateConfig template) {
        this.template = template;
        return this;
    }

    public AutoGenerator setGlobalConfig(GlobalConfig globalConfig) {
        this.globalConfig = globalConfig;
        return this;
    }

    public AutoGenerator setTemplateEngine(AbstractTemplateEngine templateEngine) {
        this.templateEngine = templateEngine;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AutoGenerator)) {
            return false;
        }
        AutoGenerator other = (AutoGenerator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ConfigBuilder this$config = this.getConfig();
        ConfigBuilder other$config = other.getConfig();
        if (this$config == null ? other$config != null : !this$config.equals(other$config)) {
            return false;
        }
        InjectionConfig this$injectionConfig = this.injectionConfig;
        InjectionConfig other$injectionConfig = other.injectionConfig;
        if (this$injectionConfig == null ? other$injectionConfig != null : !((Object)this$injectionConfig).equals(other$injectionConfig)) {
            return false;
        }
        DataSourceConfig this$dataSource = this.getDataSource();
        DataSourceConfig other$dataSource = other.getDataSource();
        if (this$dataSource == null ? other$dataSource != null : !((Object)this$dataSource).equals(other$dataSource)) {
            return false;
        }
        StrategyConfig this$strategy = this.getStrategy();
        StrategyConfig other$strategy = other.getStrategy();
        if (this$strategy == null ? other$strategy != null : !((Object)this$strategy).equals(other$strategy)) {
            return false;
        }
        PackageConfig this$packageInfo = this.getPackageInfo();
        PackageConfig other$packageInfo = other.getPackageInfo();
        if (this$packageInfo == null ? other$packageInfo != null : !((Object)this$packageInfo).equals(other$packageInfo)) {
            return false;
        }
        TemplateConfig this$template = this.getTemplate();
        TemplateConfig other$template = other.getTemplate();
        if (this$template == null ? other$template != null : !((Object)this$template).equals(other$template)) {
            return false;
        }
        GlobalConfig this$globalConfig = this.getGlobalConfig();
        GlobalConfig other$globalConfig = other.getGlobalConfig();
        if (this$globalConfig == null ? other$globalConfig != null : !((Object)this$globalConfig).equals(other$globalConfig)) {
            return false;
        }
        AbstractTemplateEngine this$templateEngine = this.getTemplateEngine();
        AbstractTemplateEngine other$templateEngine = other.getTemplateEngine();
        return !(this$templateEngine == null ? other$templateEngine != null : !this$templateEngine.equals(other$templateEngine));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AutoGenerator;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ConfigBuilder $config = this.getConfig();
        result = result * 59 + ($config == null ? 43 : $config.hashCode());
        InjectionConfig $injectionConfig = this.injectionConfig;
        result = result * 59 + ($injectionConfig == null ? 43 : ((Object)$injectionConfig).hashCode());
        DataSourceConfig $dataSource = this.getDataSource();
        result = result * 59 + ($dataSource == null ? 43 : ((Object)$dataSource).hashCode());
        StrategyConfig $strategy = this.getStrategy();
        result = result * 59 + ($strategy == null ? 43 : ((Object)$strategy).hashCode());
        PackageConfig $packageInfo = this.getPackageInfo();
        result = result * 59 + ($packageInfo == null ? 43 : ((Object)$packageInfo).hashCode());
        TemplateConfig $template = this.getTemplate();
        result = result * 59 + ($template == null ? 43 : ((Object)$template).hashCode());
        GlobalConfig $globalConfig = this.getGlobalConfig();
        result = result * 59 + ($globalConfig == null ? 43 : ((Object)$globalConfig).hashCode());
        AbstractTemplateEngine $templateEngine = this.getTemplateEngine();
        result = result * 59 + ($templateEngine == null ? 43 : $templateEngine.hashCode());
        return result;
    }

    public String toString() {
        return "AutoGenerator(config=" + this.getConfig() + ", injectionConfig=" + this.injectionConfig + ", dataSource=" + this.getDataSource() + ", strategy=" + this.getStrategy() + ", packageInfo=" + this.getPackageInfo() + ", template=" + this.getTemplate() + ", globalConfig=" + this.getGlobalConfig() + ", templateEngine=" + this.getTemplateEngine() + ")";
    }
}

