/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.prometheus.agent.service.api.impl;

import com.alibaba.nacos.api.config.annotation.NacosValue;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.pojo.ListView;
import com.google.common.base.Stopwatch;
import com.google.gson.Gson;
import com.xiaomi.data.push.nacos.NacosNaming;
import io.fabric8.kubernetes.api.model.Node;
import io.fabric8.kubernetes.api.model.NodeAddress;
import io.fabric8.kubernetes.api.model.NodeList;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.prometheus.agent.domain.Ips;
import org.apache.ozhera.prometheus.agent.service.api.PrometheusIpServiceExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(name={"service.selector.property"}, havingValue="outer")
public class PrometheusIpServiceExtensionImpl
implements PrometheusIpServiceExtension {
    private static final Logger log = LoggerFactory.getLogger(PrometheusIpServiceExtensionImpl.class);
    @Autowired
    private NacosNaming nacosNaming;
    private static ConcurrentHashMap<String, Set<String>> appIpsCache = new ConcurrentHashMap();
    public static final int PAGINATION_SIZE = 200;
    public static final String PROMETHEUS_PORT = "prometheus_port";
    public static final String JAVAAGENT_PROMETHEUS_PORT = "javaagent_prometheus_port";
    public static final String JAEGERQUERY_PROMETHEUS_PORT = "jaegerQuery_port";
    public static final String MONESTARTER_PROMETHEUS_PORT = "monestarter_prometheus_port";
    public static final String APPLICATION = "application";
    public static final String[] TESLA_FLAG = new String[]{""};
    public static final String ST_K8S_NODE = "http://localhost";
    public static final String ONLINE_K8S_NODE = "http://localhost";
    public static final String CUSTOM_JOB_PREFIX = "prometheus_custom_server_";
    public static final String CUSTOM_JOB_PORT_KEY = "ozhera_prometheus_port";
    private final Gson gson = new Gson();
    private List<Ips> starterIpsList = new ArrayList<Ips>();
    private List<Ips> javaagentIpsList = new ArrayList<Ips>();
    private List<Ips> jaegerqueryIpsList = new ArrayList<Ips>();
    private List<Ips> monequeryIpsList = new ArrayList<Ips>();
    @Value(value="${server.type}")
    private String serverType;
    @NacosValue(value="${mione.k8s.node.port}", autoRefreshed=true)
    private String machinePort;
    @NacosValue(value="${mione.k8s.container.port}", autoRefreshed=true)
    private String containerPort;
    @NacosValue(value="${jaeger_query_token}")
    private String jaegerQueryToken;
    private ReentrantLock lock = new ReentrantLock();

    @PostConstruct
    public void init() {
        new ScheduledThreadPoolExecutor(1).scheduleWithFixedDelay(() -> {
            Stopwatch sw = Stopwatch.createStarted();
            log.info("enable async to obtain nacos information");
            ConcurrentHashMap cache = new ConcurrentHashMap();
            Ips starterIps = new Ips();
            Ips javaagentIps = new Ips();
            Ips jaegerqueryIps = new Ips();
            Ips moneStarterIps = new Ips();
            HashSet starterAddresssSet = new HashSet();
            HashSet javaagentAddresssSet = new HashSet();
            HashSet jaegerqueryAddresssSet = new HashSet();
            HashSet monestarterPrometheusPortSet = new HashSet();
            ArrayList<Ips> starterIpsListTmp = new ArrayList<Ips>();
            ArrayList<Ips> javaagentIpsListTmp = new ArrayList<Ips>();
            ArrayList<Ips> jaegerqueryIpsListTmp = new ArrayList<Ips>();
            ArrayList<Ips> monestarterIpsListTmp = new ArrayList<Ips>();
            List<String> teslaFlag = Arrays.asList(TESLA_FLAG);
            try {
                Set<String> serviceNames = this.getAllServiceNames();
                log.info("service num:{} {}", (Object)serviceNames.size(), (Object)sw.elapsed(TimeUnit.MILLISECONDS));
                if (serviceNames != null && serviceNames.size() > 0) {
                    serviceNames.stream().forEach(it -> {
                        if (it == null || it.startsWith("consumers:")) {
                            return;
                        }
                        List instances = null;
                        try {
                            instances = this.nacosNaming.getAllInstances(it);
                        }
                        catch (NacosException e) {
                            log.error("Nacos.getAllInstance error,", (Throwable)e);
                        }
                        assert (instances != null);
                        instances.forEach(it5 -> {
                            if (teslaFlag.contains(it)) {
                                Set tmpIps = cache.getOrDefault(it, new HashSet());
                                tmpIps.add(it5.getIp() + ":" + it5.getPort());
                                cache.putIfAbsent(it, tmpIps);
                            }
                        });
                        List starterAddrs = instances.stream().filter(it1 -> it1.getMetadata() != null && StringUtils.startsWith((CharSequence)it, (CharSequence)CUSTOM_JOB_PREFIX)).map(it2 -> {
                            String ip = it2.getIp();
                            String port = (String)it2.getMetadata().get(CUSTOM_JOB_PORT_KEY);
                            return ip + ":" + port;
                        }).collect(Collectors.toList());
                        List javaagentAddrs = instances.stream().filter(it1 -> it1.getMetadata() != null && StringUtils.isNotEmpty((CharSequence)((CharSequence)it1.getMetadata().get(JAVAAGENT_PROMETHEUS_PORT)))).map(it2 -> {
                            String ip = it2.getIp();
                            String port = (String)it2.getMetadata().get(JAVAAGENT_PROMETHEUS_PORT);
                            return ip + ":" + port;
                        }).collect(Collectors.toList());
                        List jaegerquery = instances.stream().filter(it1 -> it1.getMetadata() != null && StringUtils.isNotEmpty((CharSequence)((CharSequence)it1.getMetadata().get(JAEGERQUERY_PROMETHEUS_PORT)))).map(it2 -> {
                            String ip = it2.getIp();
                            String port = (String)it2.getMetadata().get(JAEGERQUERY_PROMETHEUS_PORT);
                            return ip + ":" + port;
                        }).collect(Collectors.toList());
                        List moneStarterAddrs = instances.stream().filter(it1 -> it1.getMetadata() != null && StringUtils.isNotEmpty((CharSequence)((CharSequence)it1.getMetadata().get(MONESTARTER_PROMETHEUS_PORT)))).map(it2 -> {
                            String ip = it2.getIp();
                            String port = (String)it2.getMetadata().get(MONESTARTER_PROMETHEUS_PORT);
                            return ip + ":" + port;
                        }).collect(Collectors.toList());
                        instances.stream().filter(it3 -> it3.getMetadata() != null && StringUtils.isNotEmpty((CharSequence)((CharSequence)it3.getMetadata().get(APPLICATION)))).forEach(it4 -> {
                            String appName = (String)it4.getMetadata().get(APPLICATION);
                            Set tmpIps = cache.getOrDefault(appName, new HashSet());
                            if (appName.equals("tesla-gateway")) {
                                tmpIps.add(it4.getIp() + ":8080");
                            } else {
                                tmpIps.add(it4.getIp());
                            }
                            cache.putIfAbsent(appName, tmpIps);
                        });
                        starterAddresssSet.addAll(starterAddrs);
                        javaagentAddresssSet.addAll(javaagentAddrs);
                        jaegerqueryAddresssSet.addAll(jaegerquery);
                        monestarterPrometheusPortSet.addAll(moneStarterAddrs);
                    });
                }
                appIpsCache = cache;
                starterIps.setTargets(new ArrayList<String>(starterAddresssSet));
                javaagentIps.setTargets(new ArrayList<String>(javaagentAddresssSet));
                jaegerqueryIps.setTargets(new ArrayList<String>(jaegerqueryAddresssSet));
                moneStarterIps.setTargets(new ArrayList<String>(monestarterPrometheusPortSet));
                starterIpsListTmp.add(starterIps);
                javaagentIpsListTmp.add(javaagentIps);
                jaegerqueryIpsListTmp.add(jaegerqueryIps);
                monestarterIpsListTmp.add(moneStarterIps);
                this.starterIpsList = starterIpsListTmp;
                this.javaagentIpsList = javaagentIpsListTmp;
                this.jaegerqueryIpsList = jaegerqueryIpsListTmp;
                this.monequeryIpsList = monestarterIpsListTmp;
                log.info("\u5f02\u6b65\u83b7\u53d6nacos\u4fe1\u606f\u5b8c\u6210 use time:{}", (Object)sw.elapsed(TimeUnit.MILLISECONDS));
            }
            catch (Exception ex) {
                log.error("PrometheusService.init, get nacos value error", (Throwable)ex);
            }
        }, 0L, 15L, TimeUnit.SECONDS);
    }

    private Set<String> getAllServiceNames() {
        LinkedHashSet<String> serviceNames = new LinkedHashSet<String>();
        int pageIndex = 1;
        ListView listView = this.nacosNaming.getServicesOfServer(pageIndex, 200);
        List firstPageData = listView.getData();
        serviceNames.addAll(firstPageData);
        int count = listView.getCount();
        int pageNumbers = count / 200;
        int remainder = count % 200;
        if (remainder > 0) {
            ++pageNumbers;
        }
        while (pageIndex < pageNumbers) {
            listView = this.nacosNaming.getServicesOfServer(++pageIndex, 200);
            serviceNames.addAll(listView.getData());
        }
        return serviceNames;
    }

    @Override
    public List<Ips> getByType(String type) {
        if (StringUtils.isEmpty((CharSequence)type)) {
            log.info("\u83b7\u53d6ip\u5217\u8868\u65f6\uff0c type : " + type + " \u4e3a\u7a7a");
            ArrayList<Ips> defaultResult = new ArrayList<Ips>();
            Ips ips = new Ips();
            ips.setTargets(new ArrayList<String>());
            defaultResult.add(ips);
            return defaultResult;
        }
        if ("1".equals(type)) {
            return this.starterIpsList;
        }
        if ("2".equals(type)) {
            return this.javaagentIpsList;
        }
        if ("3".equals(type)) {
            return this.jaegerqueryIpsList;
        }
        if ("4".equals(type)) {
            return this.monequeryIpsList;
        }
        log.info("Obtain the ip address list, type : " + type + " illegality");
        ArrayList<Ips> defaultResult = new ArrayList<Ips>();
        Ips ips = new Ips();
        ips.setTargets(new ArrayList<String>());
        defaultResult.add(ips);
        return defaultResult;
    }

    @Override
    public Set<String> getIpsByAppName(String name) {
        return appIpsCache.getOrDefault(name, new HashSet());
    }

    private String[] getEtcd() {
        return null;
    }

    @Override
    public Set<String> getEtcdHosts() {
        return null;
    }

    @Override
    public List<Ips> getK8sNodeIp(String type) {
        ArrayList<String> res = new ArrayList<String>();
        try (DefaultKubernetesClient client = new DefaultKubernetesClient();){
            NodeList nodeList = (NodeList)client.nodes().list();
            for (Node node : nodeList.getItems()) {
                for (NodeAddress address : node.getStatus().getAddresses()) {
                    res.add(address.getAddress());
                }
            }
        }
        catch (Exception e) {
            log.error("getK8sNodeIp error:{}", (Object)e.getMessage());
        }
        log.info("getK8sNodeIp k8s node count:{}", (Object)res.size());
        ArrayList<String> result = new ArrayList<String>();
        String port = "";
        if (type.equals("node")) {
            port = this.machinePort;
        } else if (type.equals("container")) {
            port = this.containerPort;
        } else {
            return null;
        }
        String finalPort = port;
        res.forEach(item -> result.add(item + ":" + finalPort));
        ArrayList<Ips> defaultResult = new ArrayList<Ips>();
        Ips ips2 = new Ips();
        ips2.setTargets(result);
        defaultResult.add(ips2);
        return defaultResult;
    }

    private String innerRequest(String data, String url, String apiKey, String method) {
        try {
            URL requestUrl = new URL(url);
            HttpURLConnection conn = (HttpURLConnection)requestUrl.openConnection();
            Object out = null;
            conn.setRequestProperty("Expect", "");
            conn.setRequestProperty("Accept", "application/json");
            conn.setRequestProperty("Content-Type", "application/json; charset=utf-8");
            if (StringUtils.isNotBlank((CharSequence)apiKey)) {
                conn.setRequestProperty("Authorization", "Bearer " + apiKey);
            }
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setRequestMethod(method);
            conn.connect();
            if ("POST".equals(method)) {
                BufferedWriter out1 = new BufferedWriter(new OutputStreamWriter(conn.getOutputStream(), "UTF-8"));
                out1.write(data);
                out1.flush();
                out1.close();
            }
            InputStream is = conn.getInputStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            String finalStr = "";
            String str = "";
            while ((str = br.readLine()) != null) {
                finalStr = new String(str.getBytes(), "UTF-8");
            }
            is.close();
            conn.disconnect();
            log.info("innerRequest param url:{},apiKey:{},method:{}", new Object[]{url, apiKey, method});
            return finalStr;
        }
        catch (IOException e) {
            e.printStackTrace();
            return e.getMessage();
        }
    }
}

