/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.trace.etl.service.impl;

import com.alibaba.nacos.api.config.annotation.NacosValue;
import java.time.Duration;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.ozhera.trace.etl.service.RedisService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;
import redis.clients.jedis.JedisPooled;
import redis.clients.jedis.commands.JedisCommands;
import redis.clients.jedis.params.SetParams;

@Service
@ConditionalOnProperty(name={"redis.is.open"}, havingValue="true")
public class RedisServiceImpl
implements RedisService {
    private static final Logger log = LoggerFactory.getLogger(RedisServiceImpl.class);
    @Value(value="${server.type}")
    private String env;
    @NacosValue(value="${spring.redis.cluster.nodes}")
    private String clusterNodes;
    @Value(value="${spring.redis.timeout.connection}")
    private int timeout;
    @Value(value="${spring.redis.jedis.pool.max-active}")
    private int maxActive;
    @Value(value="${spring.redis.pool.max-idle}")
    private int maxIdle;
    @Value(value="${spring.redis.pool.max-wait}")
    private long maxWaitMillis;
    @NacosValue(value="${spring.redis.password}")
    private String pwd;
    @Value(value="${spring.redis.max-attempts}")
    private int maxAttempts;
    private JedisCommands jedis;
    private JedisPooled jedisPooled;
    private long ttlSeconds = 5L;
    private long waitTimeOut = 30000L;
    private SetParams disLockParam = SetParams.setParams().ex(this.ttlSeconds).nx();

    @Override
    @PostConstruct
    public void init() {
        String[] hp = this.clusterNodes.split(":");
        this.jedisPooled = StringUtils.isEmpty((CharSequence)this.pwd) ? new JedisPooled(this.getGenericObjectPoolConfig(), hp[0].trim(), Integer.valueOf(hp[1]).intValue(), this.timeout) : new JedisPooled(this.getGenericObjectPoolConfig(), hp[0].trim(), Integer.valueOf(hp[1]).intValue(), this.timeout, this.pwd);
        this.jedis = this.jedisPooled;
    }

    private GenericObjectPoolConfig getGenericObjectPoolConfig() {
        GenericObjectPoolConfig genericObjectPoolConfig = new GenericObjectPoolConfig();
        genericObjectPoolConfig.setMaxTotal(this.maxActive);
        genericObjectPoolConfig.setMaxIdle(this.maxIdle);
        genericObjectPoolConfig.setMaxWait(Duration.ofMillis(this.maxWaitMillis));
        genericObjectPoolConfig.setTimeBetweenEvictionRuns(Duration.ofMillis(5000L));
        genericObjectPoolConfig.setMinEvictableIdleTime(Duration.ofMinutes(15L));
        genericObjectPoolConfig.setTestWhileIdle(true);
        return genericObjectPoolConfig;
    }

    @Override
    public Boolean sismember(String key, String member) {
        try {
            return this.jedis.sismember(key, member);
        }
        catch (Exception e) {
            log.error("redis sismember error key:" + key + " member:" + member, (Throwable)e);
            return null;
        }
    }

    @Override
    public Long sadd(String key, String ... members) {
        try {
            return this.jedis.sadd(key, members);
        }
        catch (Exception e) {
            log.error("redis sadd error key:" + key, (Throwable)e);
            return 0L;
        }
    }

    @Override
    public Long setNx(String key, String value) {
        try {
            return this.jedis.setnx(key, value);
        }
        catch (Exception e) {
            log.error("redis sadd error key:" + key, (Throwable)e);
            return 0L;
        }
    }

    @Override
    public String get(String key) {
        try {
            return this.jedis.get(key);
        }
        catch (Exception e) {
            log.error("redis sadd error key:" + key, (Throwable)e);
            return null;
        }
    }

    @Override
    public String set(String key, String value) {
        try {
            return this.jedis.set(key, value);
        }
        catch (Exception e) {
            log.error("redis set error key:" + key, (Throwable)e);
            return null;
        }
    }

    @Override
    public String set(String key, String value, long ttl) {
        try {
            String set = this.jedis.set(key, value);
            if ("OK".equals(set)) {
                this.jedis.expire(key, ttl);
            }
            return set;
        }
        catch (Exception e) {
            log.error("redis set error key:" + key, (Throwable)e);
            return null;
        }
    }

    @Override
    public Long del(String key) {
        try {
            return this.jedis.del(key);
        }
        catch (Exception e) {
            log.error("redis del error key:" + key, (Throwable)e);
            return null;
        }
    }

    @Override
    public boolean getDisLock(String key) {
        long startTime = System.currentTimeMillis();
        try {
            do {
                if ("OK".equals(this.jedis.set(key, "1", this.disLockParam))) {
                    return true;
                }
                Thread.sleep(10L);
            } while (System.currentTimeMillis() - startTime <= this.waitTimeOut);
            log.warn("\u7b49\u5f85\u5206\u5e03\u5f0f\u9501\u8d85\u8fc730\u79d2...");
            return true;
        }
        catch (Exception e) {
            log.error("redis getDisLock error key:" + key, (Throwable)e);
            return false;
        }
    }
}

