/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata.definition.builder;

import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.common.utils.ClassUtils;
import org.apache.dubbo.metadata.definition.TypeDefinitionBuilder;
import org.apache.dubbo.metadata.definition.model.TypeDefinition;
import org.apache.dubbo.metadata.definition.util.JaketConfigurationUtils;

public final class DefaultTypeBuilder {
    public static TypeDefinition build(Class<?> clazz, Map<Class<?>, TypeDefinition> typeCache) {
        String name = clazz.getName();
        TypeDefinition td = new TypeDefinition(name);
        if (typeCache.containsKey(clazz)) {
            return typeCache.get(clazz);
        }
        if (!JaketConfigurationUtils.needAnalyzing(clazz)) {
            return td;
        }
        TypeDefinition ref = new TypeDefinition(name);
        ref.set$ref(name);
        typeCache.put(clazz, ref);
        if (!clazz.isPrimitive() && !ClassUtils.isSimpleType(clazz)) {
            List<Field> fields = org.apache.dubbo.metadata.definition.util.ClassUtils.getNonStaticFields(clazz);
            for (Field field : fields) {
                String fieldName = field.getName();
                Class<?> fieldClass = field.getType();
                Type fieldType = field.getGenericType();
                TypeDefinition fieldTd = TypeDefinitionBuilder.build(fieldType, fieldClass, typeCache);
                td.getProperties().put(fieldName, fieldTd);
            }
        }
        typeCache.put(clazz, td);
        return td;
    }

    private DefaultTypeBuilder() {
    }
}

