/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.nacos;

import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.registry.Registry;
import org.apache.dubbo.registry.nacos.NacosRegistry;
import org.apache.dubbo.registry.nacos.util.NacosNamingServiceUtils;
import org.apache.dubbo.registry.support.AbstractRegistryFactory;

public class NacosRegistryFactory
extends AbstractRegistryFactory {
    @Override
    protected String createRegistryCacheKey(URL url) {
        String namespace = url.getParameter("namespace");
        url = URL.valueOf(url.toServiceStringWithoutResolving());
        if (StringUtils.isNotEmpty(namespace) && !"dubbo".equals(namespace)) {
            url = url.addParameter("namespace", namespace);
        }
        return url.toFullString();
    }

    @Override
    protected Registry createRegistry(URL url) {
        URL nacosURL = url;
        if ("dubbo".equals(url.getParameter("namespace"))) {
            nacosURL = url.removeParameter("namespace");
        }
        return new NacosRegistry(nacosURL, NacosNamingServiceUtils.createNamingService(nacosURL));
    }
}

