/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.parse;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.log.parse.AbstractLogParser;
import org.apache.ozhera.log.parse.LogParserData;
import org.apache.ozhera.log.utils.IndexUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegexLogParser
extends AbstractLogParser {
    private static final Logger log = LoggerFactory.getLogger(RegexLogParser.class);
    private Pattern pattern;

    public RegexLogParser(LogParserData parserData) {
        super(parserData);
        this.pattern = Pattern.compile(parserData.getParseScript(), 8);
    }

    @Override
    public Map<String, Object> doParse(String logData, String ip, Long lineNum, Long collectStamp, String fileName) {
        return this.doParseSimple(logData, collectStamp);
    }

    @Override
    public Map<String, Object> doParseSimple(String logData, Long collectStamp) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        if (logData == null || logData.length() == 0) {
            return ret;
        }
        try {
            List<String> logArray = this.parseLogData(logData);
            List<String> keyNameList = IndexUtils.getKeyListSlice(this.parserData.getKeyList());
            int[] valueIndexList = Arrays.stream(this.parserData.getValueList().split(",")).mapToInt(Integer::parseInt).toArray();
            for (int i = 0; i < keyNameList.size(); ++i) {
                if (i >= valueIndexList.length || valueIndexList[i] == -1) continue;
                String value = "";
                if (valueIndexList[i] < logArray.size()) {
                    value = logArray.get(valueIndexList[i]);
                }
                ret.put(keyNameList.get(i), StringUtils.isNotEmpty((CharSequence)value) ? value.trim() : value);
            }
            this.validTimestamp(ret, collectStamp);
        }
        catch (Exception e) {
            ret.put("logsource", logData);
        }
        return ret;
    }

    @Override
    public List<String> parseLogData(String logData) throws Exception {
        ArrayList<String> ret = new ArrayList<String>();
        if (this.pattern == null) {
            throw new Exception("compile failed, empty pattern");
        }
        Matcher matcher = this.pattern.matcher(logData);
        if (matcher.find()) {
            for (int i = 1; i <= matcher.groupCount(); ++i) {
                ret.add(matcher.group(i));
            }
        }
        return ret;
    }
}

