/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.filepool;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.nutz.filepool.FilePool;
import org.nutz.filepool.Pools;
import org.nutz.filepool.SynchronizedFilePool;
import org.nutz.lang.Files;
import org.nutz.lang.Lang;
import org.nutz.lang.util.Disks;
import org.nutz.lang.util.Regex;
import org.nutz.log.Log;
import org.nutz.log.Logs;

public class NutFilePool
implements FilePool {
    private static final Log log = Logs.get();
    private File home;
    private long cursor;
    private long size;
    protected static Map<String, FilePool> pools = new HashMap<String, FilePool>();

    public NutFilePool(String homePath) {
        this(homePath, 0L);
    }

    public NutFilePool(String homePath, long size) {
        if (log.isInfoEnabled()) {
            log.infof("Init file-pool by: %s [%s]", homePath, size);
        }
        this.size = size;
        this.home = Files.createDirIfNoExists(homePath);
        if (!this.home.isDirectory()) {
            throw Lang.makeThrow("Path error '%s'! ,You must declare a real directory as the '%s' home folder.", homePath, this.getClass().getName());
        }
        this.home = new File(Disks.normalize(homePath));
        if (log.isDebugEnabled()) {
            log.debugf("file-pool.home: '%s'", this.home.getAbsolutePath());
        }
        this.cursor = NutFilePool.foundMax(this.home, this.home, 0);
        if (this.cursor < 0L) {
            this.cursor = 0L;
        }
        if (log.isInfoEnabled()) {
            log.infof("file-pool.cursor: %s", this.cursor);
        }
    }

    @Override
    public void clear() {
        Files.deleteDir(this.home);
        Files.makeDir(this.home);
        this.cursor = 0L;
    }

    @Override
    public File createFile(String suffix) {
        long id;
        File re;
        if (this.size > 0L && this.cursor >= this.size - 1L) {
            this.cursor = -1L;
        }
        if (!(re = Pools.getFileById(this.home, id = ++this.cursor, suffix)).exists()) {
            try {
                Files.createNewFile(re);
            }
            catch (IOException e) {
                throw Lang.wrapThrow(e);
            }
        }
        return re;
    }

    @Override
    public long current() {
        return this.cursor;
    }

    @Override
    public long getFileId(File f) {
        try {
            return Pools.getFileId(this.home, f);
        }
        catch (Exception e) {
            return -1L;
        }
    }

    @Override
    public File removeFile(long fId, String suffix) {
        File f = Pools.getFileById(this.home, fId, suffix);
        Files.deleteFile(f);
        return f;
    }

    @Override
    public boolean hasFile(long fId, String suffix) {
        File f = Pools.getFileById(this.home, fId, suffix);
        return f.exists();
    }

    @Override
    public File getFile(long fId, String suffix) {
        File f = Pools.getFileById(this.home, fId, suffix);
        if (!f.exists()) {
            return null;
        }
        return f;
    }

    @Override
    public File returnFile(long fId, String suffix) {
        File f = Pools.getFileById(this.home, fId, suffix);
        if (!f.exists()) {
            try {
                Files.createNewFile(f);
            }
            catch (IOException e) {
                throw Lang.wrapThrow(e);
            }
        }
        return f;
    }

    @Override
    public File createDir() {
        if (this.size > 0L && this.cursor >= this.size) {
            this.cursor = -1L;
        }
        long id = ++this.cursor;
        if (this.size > 0L && id >= this.size) {
            Lang.makeThrow("Id (%d) is out of range (%d)", id, this.size);
        }
        return Files.createDirIfNoExists(Pools.getFilePathById(this.home, id, null));
    }

    @Override
    public File removeDir(long fId) {
        File f = Pools.getFileById(this.home, fId, null);
        if (f.isDirectory()) {
            Files.deleteDir(f);
        } else {
            Files.deleteFile(f);
        }
        return f;
    }

    @Override
    public boolean hasDir(long fId) {
        File f = Pools.getFileById(this.home, fId, null);
        return f.exists();
    }

    @Override
    public File getDir(long fId) {
        File f = Pools.getFileById(this.home, fId, null);
        if (!f.exists()) {
            return null;
        }
        return f;
    }

    @Override
    public File returnDir(long fId) {
        File f = Pools.getFileById(this.home, fId, null);
        if (!f.exists()) {
            Files.makeDir(f);
        }
        return f;
    }

    public static FilePool getOrCreatePool(String path, long limit) {
        FilePool pool = pools.get(path);
        if (pool == null) {
            pool = new NutFilePool(path, limit);
            pool = new SynchronizedFilePool(pool);
            pools.put(path, pool);
        }
        return pool;
    }

    public static void clearPools() {
        pools.clear();
    }

    protected static long foundMax(File home, File current, int level) {
        if (level == 8) {
            if (current.isDirectory()) {
                return -1L;
            }
            return Pools.getFileId(home, current);
        }
        if (!current.isDirectory()) {
            return -1L;
        }
        int next_level = level + 1;
        ArrayList<String> names = new ArrayList<String>();
        for (File f : current.listFiles()) {
            if (!Regex.match("^([\\d|A-F]{2})([.][a-zA-Z]{1,})?$", f.getName())) continue;
            names.add(f.getName());
        }
        Collections.sort(names);
        Collections.reverse(names);
        for (String name : names) {
            File next = new File(current, name);
            long max = NutFilePool.foundMax(home, next, next_level);
            if (max <= -1L) continue;
            return max;
        }
        return -1L;
    }
}

