/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.ioc.loader.combo;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.nutz.aop.interceptor.async.AsyncAopIocLoader;
import org.nutz.aop.interceptor.ioc.TransIocLoader;
import org.nutz.ioc.IocLoader;
import org.nutz.ioc.IocLoading;
import org.nutz.ioc.ObjectLoadException;
import org.nutz.ioc.loader.annotation.AnnotationIocLoader;
import org.nutz.ioc.loader.json.JsonLoader;
import org.nutz.ioc.loader.properties.PropertiesIocLoader;
import org.nutz.ioc.loader.xml.XmlIocLoader;
import org.nutz.ioc.meta.IocObject;
import org.nutz.json.Json;
import org.nutz.lang.Lang;
import org.nutz.lang.Mirror;
import org.nutz.lang.Strings;
import org.nutz.lang.util.AbstractLifeCycle;
import org.nutz.lang.util.Callback;
import org.nutz.lang.util.LifeCycle;
import org.nutz.log.Log;
import org.nutz.log.Logs;

public class ComboIocLoader
extends AbstractLifeCycle
implements IocLoader {
    private static final Log log = Logs.get();
    private List<IocLoader> iocLoaders = new ArrayList<IocLoader>();
    protected Map<String, IocObject> iobjs = new HashMap<String, IocObject>();
    protected static Map<String, Class<? extends IocLoader>> loaders = new HashMap<String, Class<? extends IocLoader>>();

    public ComboIocLoader(String ... args) throws ClassNotFoundException {
        if (loaders.isEmpty()) {
            loaders.put("js", JsonLoader.class);
            loaders.put("json", JsonLoader.class);
            loaders.put("xml", XmlIocLoader.class);
            loaders.put("annotation", AnnotationIocLoader.class);
            loaders.put("anno", AnnotationIocLoader.class);
            loaders.put("trans", TransIocLoader.class);
            loaders.put("tx", TransIocLoader.class);
            loaders.put("props", PropertiesIocLoader.class);
            loaders.put("properties", PropertiesIocLoader.class);
            loaders.put("async", AsyncAopIocLoader.class);
        }
        ArrayList<String> argsList = null;
        String currentClassName = null;
        for (String str : args) {
            if (str.length() > 0 && str.charAt(0) == '*') {
                if (argsList != null) {
                    this.createIocLoader(currentClassName, (List<String>)argsList);
                }
                currentClassName = str.substring(1);
                argsList = new ArrayList<String>();
                continue;
            }
            if (argsList == null) {
                throw new IllegalArgumentException("ioc args without Loader ClassName. " + Arrays.toString(args));
            }
            argsList.add(str);
        }
        if (currentClassName != null) {
            this.createIocLoader(currentClassName, argsList);
        }
    }

    private void createIocLoader(String className, List<String> args) throws ClassNotFoundException {
        Class<IocLoader> klass = loaders.get(className);
        if (klass == null) {
            if (!className.contains(".")) {
                HashSet<String> _names = new HashSet<String>();
                String uccp = Strings.upperFirst(className);
                _names.add(String.format("org.nutz.integration.%s.%sIocLoader", className, uccp));
                _names.add(String.format("org.nutz.integration.%s.%sAopConfigure", className, uccp));
                _names.add(String.format("org.nutz.plugins.%s.%sIocLoader", className, uccp));
                _names.add(String.format("org.nutz.plugins.%s.%sAopConfigure", className, uccp));
                for (String _className : _names) {
                    klass = Lang.loadClassQuite(_className);
                    if (klass == null) continue;
                    log.debug("found " + className + " -- " + _className);
                    break;
                }
            }
            if (klass == null) {
                klass = Lang.loadClass(className);
            }
        }
        this.iocLoaders.add((IocLoader)((Object)Mirror.me(klass).born(args.toArray(new Object[args.size()]))));
    }

    public ComboIocLoader(IocLoader ... loaders) {
        for (IocLoader iocLoader : loaders) {
            if (iocLoader == null) continue;
            this.iocLoaders.add(iocLoader);
        }
    }

    @Override
    public String[] getName() {
        ArrayList<String> list = new ArrayList<String>();
        for (IocLoader iocLoader : this.iocLoaders) {
            for (String name : iocLoader.getName()) {
                list.add(name);
            }
        }
        return list.toArray(new String[list.size()]);
    }

    @Override
    public boolean has(String name) {
        for (IocLoader iocLoader : this.iocLoaders) {
            if (!iocLoader.has(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public IocObject load(IocLoading loading, String name) throws ObjectLoadException {
        for (IocLoader loader : this.iocLoaders) {
            if (!loader.has(name)) continue;
            IocObject iocObject = loader.load(loading, name);
            this.printFoundIocBean(name, loader);
            this.iobjs.put(name, iocObject);
            return iocObject;
        }
        throw new ObjectLoadException("Object '" + name + "' without define!");
    }

    public Set<String> getNamesByTypes(IocLoading loading, Class<?> klass) {
        HashSet<String> names = new HashSet<String>();
        for (IocLoader loader : this.iocLoaders) {
            for (String name : loader.getName()) {
                if (names.contains(name)) continue;
                try {
                    IocObject iobj = loader.load(loading, name);
                    if (iobj.getType() == null || !klass.isAssignableFrom(iobj.getType())) continue;
                    names.add(name);
                }
                catch (ObjectLoadException objectLoadException) {
                    // empty catch block
                }
            }
        }
        return names;
    }

    public Set<String> getNamesByAnnotation(IocLoading loading, Class<? extends Annotation> klass) {
        HashSet<String> names = new HashSet<String>();
        for (IocLoader loader : this.iocLoaders) {
            for (String name : loader.getName()) {
                if (names.contains(name)) continue;
                try {
                    IocObject iobj = loader.load(loading, name);
                    if (iobj.getType() == null || iobj.getType().getAnnotation(klass) == null) continue;
                    names.add(name);
                }
                catch (ObjectLoadException objectLoadException) {
                    // empty catch block
                }
            }
        }
        return names;
    }

    public void each(IocLoading loading, Callback<IocObject> callback) throws ObjectLoadException {
        for (IocLoader loader : this.iocLoaders) {
            for (String name : loader.getName()) {
                callback.invoke(loader.load(loading, name));
            }
        }
    }

    public void addLoader(IocLoader loader) {
        if (null != loader) {
            if (this.iocLoaders.contains(loader)) {
                return;
            }
            this.iocLoaders.add(loader);
        }
    }

    protected void printFoundIocBean(String name, IocLoader loader) {
        if (log.isDebugEnabled()) {
            String printName;
            if (loader instanceof AnnotationIocLoader) {
                String packages = Arrays.toString(((AnnotationIocLoader)loader).getPackages());
                printName = "AnnotationIocLoader(packages=" + packages + ")";
            } else if (loader instanceof JsonLoader && ((JsonLoader)loader).getPaths() != null) {
                String paths = Arrays.toString(((JsonLoader)loader).getPaths());
                printName = "JsonLoader(paths=" + paths + ")";
            } else {
                printName = loader.getClass().getSimpleName() + "@" + loader.hashCode();
            }
            log.debugf("Found IocObject(%s) in %s", name, printName);
        }
    }

    public Class<?> getType(IocLoading loading, String beanName) throws ObjectLoadException {
        for (IocLoader loader : this.iocLoaders) {
            IocObject iobj;
            if (!loader.has(beanName) || (iobj = loader.load(loading, beanName)).getType() == null) continue;
            return iobj.getType();
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("/*ComboIocLoader*/\n{");
        for (IocLoader loader : this.iocLoaders) {
            String str = Json.toJson(loader);
            str = str.replaceFirst("[{]", "");
            int index = str.lastIndexOf("}");
            StringBuilder sb2 = new StringBuilder(str);
            sb2.setCharAt(index, ' ');
            sb.append((CharSequence)sb2).append("\n");
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public void init() throws Exception {
        for (IocLoader loader : this.iocLoaders) {
            if (!(loader instanceof LifeCycle)) continue;
            ((LifeCycle)((Object)loader)).init();
        }
    }

    @Override
    public void depose() throws Exception {
        for (IocLoader loader : this.iocLoaders) {
            if (!(loader instanceof LifeCycle)) continue;
            ((LifeCycle)((Object)loader)).depose();
        }
    }

    public void clear() {
        this.iobjs.clear();
    }
}

