/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.log.impl;

import java.util.Date;
import org.nutz.lang.Times;
import org.nutz.log.Log;
import org.nutz.log.LogAdapter;
import org.nutz.log.impl.AbstractLog;
import org.nutz.plugin.Plugin;

public class SystemLogAdapter
implements LogAdapter,
Plugin {
    @Override
    public Log getLogger(String className) {
        return SystemLog.me();
    }

    @Override
    public boolean canWork() {
        return true;
    }

    public static class SystemLog
    extends AbstractLog {
        private static final SystemLog me = new SystemLog();
        private static boolean warned;

        static SystemLog me() {
            if (!warned) {
                me.info("Select SystemLog as Nutz.Log implement");
                warned = true;
            }
            return me;
        }

        private SystemLog() {
            this.isInfoEnabled = true;
            this.isDebugEnabled = true;
        }

        @Override
        public void debug(Object message, Throwable t) {
            if (this.isDebugEnabled()) {
                this.printOut("DEBUG", message, t);
            }
        }

        @Override
        public void error(Object message, Throwable t) {
            if (this.isErrorEnabled()) {
                this.errorOut("ERROR", message, t);
            }
        }

        @Override
        public void fatal(Object message, Throwable t) {
            if (this.isFatalEnabled()) {
                this.errorOut("FATAL", message, t);
            }
        }

        @Override
        public void info(Object message, Throwable t) {
            if (this.isInfoEnabled()) {
                this.printOut("INFO", message, t);
            }
        }

        @Override
        public void trace(Object message, Throwable t) {
            if (this.isTraceEnabled()) {
                this.printOut("TRACE", message, t);
            }
        }

        @Override
        public void warn(Object message, Throwable t) {
            if (this.isWarnEnabled()) {
                this.errorOut("WARN", message, t);
            }
        }

        private void printOut(String level, Object message, Throwable t) {
            System.out.printf("%s %s [%s] %s\n", Times.sDTms2(new Date()), level, Thread.currentThread().getName(), message);
            if (t != null) {
                t.printStackTrace(System.out);
            }
        }

        private void errorOut(String level, Object message, Throwable t) {
            System.err.printf("%s %s [%s] %s\n", Times.sDTms2(new Date()), level, Thread.currentThread().getName(), message);
            if (t != null) {
                t.printStackTrace(System.err);
            }
        }

        @Override
        protected void log(int level, Object message, Throwable tx) {
            switch (level) {
                case 50: {
                    this.fatal(message, tx);
                    break;
                }
                case 40: {
                    this.error(message, tx);
                    break;
                }
                case 30: {
                    this.warn(message, tx);
                    break;
                }
                case 20: {
                    this.info(message, tx);
                    break;
                }
                case 10: {
                    this.debug(message, tx);
                    break;
                }
                case 0: {
                    this.trace(message, tx);
                }
            }
        }
    }
}

