/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.net;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import org.nutz.lang.Lang;
import org.nutz.log.Log;
import org.nutz.log.Logs;

public class TcpConnector {
    private static final Log log = Logs.get();
    private Socket socket;
    private BufferedReader reader;
    private Writer writer;
    private String host;
    private int port;

    public TcpConnector connect() {
        if (this.isClosed()) {
            log.infof("Connect socket <-> %s:%d", this.host, this.port);
            try {
                this.socket = new Socket(InetAddress.getByName(this.host), this.port);
                this.socket.setTcpNoDelay(true);
                this.reader = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
                this.writer = new OutputStreamWriter(this.socket.getOutputStream());
            }
            catch (UnknownHostException e) {
                log.warnf("Unknown host '%s:%d'", this.host, this.port);
                throw Lang.wrapThrow(e);
            }
            catch (IOException e) {
                log.warnf("IOError '%s:%d'", this.host, this.port);
                throw Lang.wrapThrow(e);
            }
        }
        return this;
    }

    public String readLine() throws IOException {
        return this.reader.readLine();
    }

    public TcpConnector write(String str) throws IOException {
        if (this.isClosed()) {
            this.connect();
        }
        this.writer.write(str);
        this.writer.flush();
        return this;
    }

    public TcpConnector writeLine(String str) throws IOException {
        return this.write(str + "\n");
    }

    public boolean isClosed() {
        return null == this.socket;
    }

    public TcpConnector close() {
        if (null != this.socket) {
            try {
                log.infof("Close socket <-> %s:%d", this.host, this.port);
                this.socket.close();
            }
            catch (IOException e) {
                log.warn("fail to close", e);
            }
        }
        this.socket = null;
        this.reader = null;
        this.writer = null;
        return this;
    }

    public TcpConnector(String host, int port) {
        this.host = host;
        this.port = port;
        this.socket = null;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }
}

