/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.resource.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.nutz.lang.Lang;
import org.nutz.resource.NutResource;
import org.nutz.resource.Scans;

public class JarResource
extends NutResource {
    protected String jarPath;
    protected String entryName;

    public JarResource(String jarPath, String entryName) {
        this.jarPath = jarPath;
        this.entryName = entryName;
        this.priority = 50;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        ZipInputStream zis = Scans.makeZipInputStream(this.jarPath);
        ZipEntry ens = null;
        while (null != (ens = zis.getNextEntry())) {
            if (!ens.getName().equals(this.entryName)) continue;
            return zis;
        }
        throw Lang.impossible();
    }

    @Override
    public int hashCode() {
        return (this.jarPath + ":" + this.entryName).hashCode();
    }

    @Override
    public String toString() {
        return String.format("Jar[%s:%s]", this.jarPath, this.entryName);
    }
}

