/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.youpin.docean.plugin.dubbo;

import com.xiaomi.youpin.docean.plugin.dubbo.DubboRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.ApplicationConfig;
import org.apache.dubbo.config.ReferenceConfig;
import org.apache.dubbo.config.ReferenceConfigBase;
import org.apache.dubbo.config.RegistryConfig;
import org.apache.dubbo.config.utils.ReferenceConfigCache;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.service.GenericService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DubboCall {
    private static final Logger log = LoggerFactory.getLogger(DubboCall.class);
    private ApplicationConfig applicationConfig;
    private RegistryConfig registryConfig;

    public DubboCall(ApplicationConfig applicationConfig, RegistryConfig registryConfig) {
        this.applicationConfig = applicationConfig;
        this.registryConfig = registryConfig;
    }

    public Object call(DubboRequest request) {
        RpcContext.getContext().setAttachment("timeout", String.valueOf(request.getTimeout()));
        String key = ReferenceConfigCache.getKey((String)request.getServiceName(), (String)request.getGroup(), (String)request.getVersion());
        GenericService genericService = (GenericService)ReferenceConfigCache.getCache().get(key);
        boolean create = false;
        if (null == genericService) {
            ReferenceConfig reference = new ReferenceConfig();
            reference.setApplication(this.applicationConfig);
            reference.setRegistry(this.registryConfig);
            reference.setInterface(request.getServiceName());
            reference.setGeneric(Boolean.valueOf(true));
            reference.setCheck(Boolean.valueOf(false));
            reference.setGroup(request.getGroup());
            reference.setVersion(request.getVersion());
            reference.setTimeout(Integer.valueOf(request.getTimeout()));
            ReferenceConfigCache cache = ReferenceConfigCache.getCache();
            genericService = (GenericService)cache.get((ReferenceConfigBase)reference);
            create = true;
        }
        log.info("call key:{} {} {}", new Object[]{key, genericService, create});
        if (StringUtils.isNotEmpty((CharSequence)request.getAddr())) {
            String[] ss = request.getAddr().split(":");
            RpcContext.getContext().setAttachment("_must_provider_ip_port_", "true");
            RpcContext.getContext().setAttachment("_provider_ip_", ss[0]);
            RpcContext.getContext().setAttachment("_provider_port_", ss[1]);
        }
        Object res = null;
        try {
            res = genericService.$invoke(request.getMethodName(), request.getParameterTypes(), request.getArgs());
        }
        catch (Exception e) {
            log.error("DubboTask call error", (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            RpcContext.getContext().clearAttachments();
        }
        return res;
    }
}

