/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.agent.extension;

import com.google.common.collect.Lists;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.PartitionInfo;
import org.apache.ozhera.log.agent.common.HashUtil;
import org.apache.ozhera.log.agent.common.trace.TraceUtil;
import org.apache.ozhera.log.agent.export.MsgExporter;
import org.apache.ozhera.log.api.enums.LogTypeEnum;
import org.apache.ozhera.log.api.model.msg.LineMessage;
import org.apache.ozhera.tspandata.TSpanData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaExporter
implements MsgExporter {
    private static final Logger log = LoggerFactory.getLogger(KafkaExporter.class);
    private Producer producer;
    private String topic;
    private String tag;
    private boolean isCommonTag;
    private Integer batchSize;
    private Integer maxPartitionPer = 4;

    public KafkaExporter(Producer mqProducer, String tag) {
        this.producer = mqProducer;
        this.tag = tag;
    }

    @Override
    public void close() {
    }

    @Override
    public void export(LineMessage message) {
        this.export(Lists.newArrayList((Object[])new LineMessage[]{message}));
    }

    @Override
    public void export(List<LineMessage> messageList) {
        if (messageList.isEmpty()) {
            return;
        }
        List partitions = this.producer.partitionsFor(this.topic);
        for (LineMessage message : messageList) {
            ProducerRecord<String, String> record = this.buildProducerRecord(message, partitions);
            if (record == null) continue;
            this.producer.send(record, (metadata, e) -> {
                if (null != e) {
                    log.error("send message to kafka error", (Throwable)e);
                }
            });
        }
    }

    private ProducerRecord<String, String> buildProducerRecord(LineMessage message, List<PartitionInfo> partitions) {
        String messageType = message.getProperties(LineMessage.KEY_MESSAGE_TYPE);
        ProducerRecord record = null;
        if (String.valueOf(LogTypeEnum.ORIGIN_LOG.getType()).equals(messageType)) {
            record = new ProducerRecord(this.topic, (Object)this.tag, (Object)gson.toJson((Object)message.getMsgBody()));
        } else if (OPENTELEMETRY_TYPE.equals(messageType)) {
            byte[] bytes;
            String msgBody = message.getMsgBody();
            TSpanData tSpanData = TraceUtil.toTSpanData(msgBody);
            if (tSpanData != null && (bytes = TraceUtil.toBytes(tSpanData)) != null) {
                String spanMessage = new String(bytes, StandardCharsets.ISO_8859_1);
                record = new ProducerRecord(this.topic, (Object)this.tag, (Object)spanMessage);
                String appName = tSpanData.getExtra().getServiceName();
                if (appName != null) {
                    int key = ThreadLocalRandom.current().nextInt(this.maxPartitionPer);
                    appName = String.format("p%s%s", key, appName);
                    int hash = HashUtil.consistentHash(appName, partitions.size());
                    int partition = partitions.get(hash).partition();
                    record = new ProducerRecord(this.topic, Integer.valueOf(partition), (Object)this.tag, (Object)spanMessage);
                }
            }
        } else {
            record = new ProducerRecord(this.topic, (Object)this.tag, (Object)gson.toJson((Object)message));
        }
        return record;
    }

    public void setTopic(String topic) {
        this.topic = topic;
        if (topic.startsWith("common_mq_miLog")) {
            this.isCommonTag = true;
        }
    }

    public Integer getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(Integer batchSize) {
        this.batchSize = batchSize;
    }

    @Override
    public int batchExportSize() {
        if (null == this.batchSize || this.batchSize < 0) {
            return 200;
        }
        return this.batchSize;
    }
}

