/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.youpin.docean.plugin.mybatisplus.interceptor;

import com.xiaomi.youpin.docean.aop.AopContext;
import com.xiaomi.youpin.docean.plugin.cat.CatInterceptor;
import com.xiaomi.youpin.docean.plugin.mybatisplus.MybatisTransaction;
import com.xiaomi.youpin.docean.plugin.mybatisplus.Transactional;
import com.xiaomi.youpin.docean.plugin.mybatisplus.TransactionalContext;
import java.lang.reflect.Method;

public class TransactionalInterceptor
extends CatInterceptor {
    public void before(AopContext context, Method method, Object[] args) {
        super.before(context, method, args);
        TransactionalContext.getContext().set(new MybatisTransaction(null, false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object after(AopContext context, Method method, Object res) {
        Object object;
        MybatisTransaction transaction = TransactionalContext.getContext().get();
        try {
            Object r = super.after(context, method, res);
            transaction.commit();
            object = r;
        }
        catch (Throwable throwable) {
            transaction.close();
            TransactionalContext.getContext().close();
            throw throwable;
        }
        transaction.close();
        TransactionalContext.getContext().close();
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exception(AopContext context, Method method, Throwable ex) {
        super.exception(context, method, ex);
        MybatisTransaction transaction = TransactionalContext.getContext().get();
        try {
            transaction.rollback();
        }
        finally {
            transaction.close();
            TransactionalContext.getContext().close();
        }
    }

    public boolean needEnhance(Method method) {
        Transactional tr = method.getAnnotation(Transactional.class);
        return tr.type().equals("mybatis");
    }
}

