/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.support.csv;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.reader.ObjectReaderAdapter;
import com.alibaba.fastjson2.stream.StreamReader;
import com.alibaba.fastjson2.support.csv.CSVReader;
import com.alibaba.fastjson2.util.DateUtils;
import com.alibaba.fastjson2.util.IOUtils;
import com.alibaba.fastjson2.util.TypeUtils;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;

class CSVReaderUTF8
extends CSVReader {
    byte[] buf;
    InputStream input;
    Charset charset = StandardCharsets.UTF_8;

    CSVReaderUTF8(StreamReader.Feature ... features) {
        for (StreamReader.Feature feature : features) {
            this.features |= feature.mask;
        }
    }

    CSVReaderUTF8(byte[] bytes, int off, int len, ObjectReaderAdapter objectReader) {
        super(objectReader);
        this.buf = bytes;
        this.off = off;
        this.end = off + len;
    }

    CSVReaderUTF8(byte[] bytes, int off, int len, Type[] types) {
        super(types);
        this.buf = bytes;
        this.off = off;
        this.end = off + len;
        this.types = types;
    }

    CSVReaderUTF8(InputStream input, Charset charset, Type[] types) {
        super(types);
        this.charset = charset;
        this.input = input;
    }

    CSVReaderUTF8(InputStream input, Charset charset, ObjectReaderAdapter objectReader) {
        super(objectReader);
        this.charset = charset;
        this.input = input;
    }

    @Override
    protected boolean seekLine() throws IOException {
        if (this.buf == null && this.input != null) {
            this.buf = new byte[524288];
            int cnt = this.input.read(this.buf);
            if (cnt == -1) {
                this.inputEnd = true;
                return false;
            }
            this.end = cnt;
            if (this.end > 3 && this.buf[0] == -17 && this.buf[1] == -69 && this.buf[2] == -65) {
                this.lineNextStart = this.off = 3;
            }
        }
        for (int k = 0; k < 3; ++k) {
            this.lineTerminated = false;
            for (int i = this.off; i < this.end; ++i) {
                int n;
                byte ch;
                if (i + 4 < this.end) {
                    byte b0 = this.buf[i];
                    byte b1 = this.buf[i + 1];
                    byte b2 = this.buf[i + 2];
                    byte b3 = this.buf[i + 3];
                    if (b0 > 34 && b1 > 34 && b2 > 34 && b3 > 34) {
                        this.lineSize += 4;
                        i += 3;
                        continue;
                    }
                }
                if ((ch = this.buf[i]) == 34) {
                    ++this.lineSize;
                    if (!this.quote) {
                        this.quote = true;
                        continue;
                    }
                    n = i + 1;
                    if (n >= this.end) break;
                    if (this.buf[n] == 34) {
                        ++this.lineSize;
                        ++i;
                        continue;
                    }
                    this.quote = false;
                    continue;
                }
                if (this.quote) {
                    ++this.lineSize;
                    continue;
                }
                if (ch == 10) {
                    if (this.lineSize > 0 || (this.features & StreamReader.Feature.IgnoreEmptyLine.mask) == 0L) {
                        ++this.rowCount;
                    }
                    this.lineTerminated = true;
                    this.lineSize = 0;
                    this.lineEnd = i;
                    this.lineStart = this.lineNextStart;
                    this.lineNextStart = this.off = i + 1;
                    break;
                }
                if (ch == 13) {
                    if (this.lineSize > 0 || (this.features & StreamReader.Feature.IgnoreEmptyLine.mask) == 0L) {
                        ++this.rowCount;
                    }
                    this.lineTerminated = true;
                    this.lineSize = 0;
                    this.lineEnd = i;
                    n = i + 1;
                    if (n >= this.end) break;
                    if (this.buf[n] == 10) {
                        ++i;
                    }
                    this.lineStart = this.lineNextStart;
                    this.lineNextStart = this.off = i + 1;
                    break;
                }
                ++this.lineSize;
            }
            if (!this.lineTerminated) {
                if (this.input != null && !this.inputEnd) {
                    int cnt;
                    int len = this.end - this.off;
                    if (this.off > 0) {
                        if (len > 0) {
                            System.arraycopy(this.buf, this.off, this.buf, 0, len);
                        }
                        this.lineNextStart = 0;
                        this.lineStart = 0;
                        this.off = 0;
                        this.end = len;
                        this.quote = false;
                    }
                    if ((cnt = this.input.read(this.buf, this.end, this.buf.length - this.end)) == -1) {
                        this.inputEnd = true;
                        if (this.off == this.end) {
                            return false;
                        }
                    } else {
                        this.end += cnt;
                        continue;
                    }
                }
                this.lineStart = this.lineNextStart;
                this.lineEnd = this.end;
                ++this.rowCount;
                this.lineSize = 0;
                this.off = this.end;
            }
            this.lineTerminated = this.off == this.end;
            break;
        }
        return true;
    }

    Object readValue(byte[] bytes, int off, int len, Type type) {
        if (type == Integer.class) {
            return TypeUtils.parseInt(bytes, off, len);
        }
        if (type == Long.class) {
            return TypeUtils.parseLong(bytes, off, len);
        }
        if (type == BigDecimal.class) {
            return TypeUtils.parseBigDecimal(bytes, off, len);
        }
        if (type == Float.class) {
            if (len == 0) {
                return null;
            }
            return Float.valueOf(TypeUtils.parseFloat(bytes, off, len));
        }
        if (type == Double.class) {
            if (len == 0) {
                return null;
            }
            return TypeUtils.parseDouble(bytes, off, len);
        }
        if (type == Date.class) {
            long millis = DateUtils.parseMillis(bytes, off, len, this.charset);
            return new Date(millis);
        }
        String str = new String(bytes, off, len, this.charset);
        return TypeUtils.cast((Object)str, type);
    }

    @Override
    public boolean isEnd() {
        return this.inputEnd;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object[] readLineValues(boolean strings) {
        ArrayList<Object> valueList;
        Object[] values;
        block60: {
            Object value;
            int columnIndex;
            block56: {
                Type type;
                int valueSize;
                int valueStart;
                block61: {
                    try {
                        if (this.inputEnd) {
                            return null;
                        }
                        if (this.input == null && this.off >= this.end) {
                            return null;
                        }
                        boolean result = this.seekLine();
                        if (!result) {
                            return null;
                        }
                    }
                    catch (IOException e) {
                        throw new JSONException("seekLine error", e);
                    }
                    values = null;
                    valueList = null;
                    if (this.columns != null) {
                        values = strings ? new String[this.columns.size()] : new Object[this.columns.size()];
                    }
                    boolean quote = false;
                    valueStart = this.lineStart;
                    valueSize = 0;
                    int escapeCount = 0;
                    columnIndex = 0;
                    for (int i = this.lineStart; i < this.lineEnd; ++i) {
                        block58: {
                            Object value2;
                            block55: {
                                Type type2;
                                block59: {
                                    byte ch;
                                    block54: {
                                        block57: {
                                            ch = this.buf[i];
                                            if (!quote) break block57;
                                            if (ch == 34) {
                                                int n = i + 1;
                                                if (n < this.lineEnd) {
                                                    byte c1 = this.buf[n];
                                                    if (c1 == 34) {
                                                        valueSize += 2;
                                                        ++escapeCount;
                                                        ++i;
                                                        continue;
                                                    }
                                                    if (c1 == 44) {
                                                        ++i;
                                                        ch = c1;
                                                    }
                                                    break block54;
                                                } else if (n == this.lineEnd) {
                                                    break;
                                                }
                                                break block54;
                                            } else {
                                                ++valueSize;
                                                continue;
                                            }
                                        }
                                        if (ch == 34) {
                                            quote = true;
                                            continue;
                                        }
                                    }
                                    if (ch != 44) break block58;
                                    Type type3 = type2 = this.types != null && columnIndex < this.types.length ? this.types[columnIndex] : null;
                                    if (!quote) break block59;
                                    if (escapeCount == 0) {
                                        if (type2 == null || type2 == String.class || type2 == Object.class) {
                                            value2 = new String(this.buf, valueStart + 1, valueSize, this.charset);
                                            break block55;
                                        } else {
                                            try {
                                                value2 = this.readValue(this.buf, valueStart + 1, valueSize, type2);
                                            }
                                            catch (Exception e) {
                                                value2 = this.error(columnIndex, e);
                                            }
                                        }
                                        break block55;
                                    } else {
                                        byte[] bytes = new byte[valueSize - escapeCount];
                                        int valueEnd = valueStart + valueSize;
                                        int k = 0;
                                        for (int j = valueStart + 1; j < valueEnd; ++j) {
                                            byte c = this.buf[j];
                                            bytes[k++] = c;
                                            if (c != 34 || this.buf[j + 1] != 34) continue;
                                            ++j;
                                        }
                                        if (type2 == null || type2 == String.class || type2 == Object.class) {
                                            value2 = new String(bytes, 0, bytes.length, this.charset);
                                            break block55;
                                        } else {
                                            try {
                                                value2 = this.readValue(bytes, 0, bytes.length, type2);
                                            }
                                            catch (Exception e) {
                                                value2 = this.error(columnIndex, e);
                                            }
                                        }
                                    }
                                    break block55;
                                }
                                if (type2 == null || type2 == String.class || type2 == Object.class || strings) {
                                    value2 = new String(this.buf, valueStart, valueSize, this.charset);
                                } else {
                                    try {
                                        value2 = this.readValue(this.buf, valueStart, valueSize, type2);
                                    }
                                    catch (Exception e) {
                                        value2 = this.error(columnIndex, e);
                                    }
                                }
                            }
                            if (values != null) {
                                if (columnIndex < values.length) {
                                    values[columnIndex] = value2;
                                }
                            } else {
                                if (valueList == null) {
                                    valueList = new ArrayList();
                                }
                                valueList.add(value2);
                            }
                            quote = false;
                            valueStart = i + 1;
                            valueSize = 0;
                            escapeCount = 0;
                            ++columnIndex;
                            continue;
                        }
                        ++valueSize;
                    }
                    if (valueSize <= 0) break block60;
                    Type type4 = type = this.types != null && columnIndex < this.types.length ? this.types[columnIndex] : null;
                    if (!quote) break block61;
                    if (escapeCount == 0) {
                        if (type == null || type == String.class || type == Object.class) {
                            value = new String(this.buf, valueStart + 1, valueSize, this.charset);
                            break block56;
                        } else {
                            try {
                                value = this.readValue(this.buf, valueStart + 1, valueSize, type);
                            }
                            catch (Exception e) {
                                value = this.error(columnIndex, e);
                            }
                        }
                        break block56;
                    } else {
                        byte[] bytes = new byte[valueSize - escapeCount];
                        int valueEnd = this.lineEnd;
                        int k = 0;
                        for (int j = valueStart + 1; j < valueEnd; ++j) {
                            byte c = this.buf[j];
                            bytes[k++] = c;
                            if (c != 34 || this.buf[j + 1] != 34) continue;
                            ++j;
                        }
                        if (type == null || type == String.class || type == Object.class) {
                            value = new String(bytes, 0, bytes.length, this.charset);
                            break block56;
                        } else {
                            try {
                                value = this.readValue(bytes, 0, bytes.length, type);
                            }
                            catch (Exception e) {
                                value = this.error(columnIndex, e);
                            }
                        }
                    }
                    break block56;
                }
                if (type == null || type == String.class || type == Object.class || strings) {
                    value = new String(this.buf, valueStart, valueSize, this.charset);
                } else {
                    try {
                        value = this.readValue(this.buf, valueStart, valueSize, type);
                    }
                    catch (Exception e) {
                        value = this.error(columnIndex, e);
                    }
                }
            }
            if (values != null) {
                if (columnIndex < values.length) {
                    values[columnIndex] = value;
                }
            } else {
                if (valueList == null) {
                    valueList = new ArrayList<Object>();
                }
                valueList.add(value);
            }
        }
        if (values == null && valueList != null) {
            values = strings ? new String[valueList.size()] : new Object[valueList.size()];
            valueList.toArray(values);
        }
        return values;
    }

    @Override
    public void close() {
        if (this.input != null) {
            IOUtils.close(this.input);
        }
    }

    @Override
    public void statAll() {
        CSVReader.ByteArrayConsumer consumer = (row, column, bytes, off, len, charset) -> {
            StreamReader.ColumnStat stat = this.getColumnStat(column);
            stat.stat(bytes, off, len, charset);
        };
        this.readAll(consumer);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void readAll(CSVReader.ByteArrayConsumer consumer) {
        while (true) {
            try {
                if (this.inputEnd) {
                    return;
                }
                if (this.input == null && this.off >= this.end) {
                    return;
                }
                boolean result = this.seekLine();
                if (!result) {
                    return;
                }
            }
            catch (IOException e) {
                throw new JSONException("seekLine error", e);
            }
            boolean quote = false;
            int valueStart = this.lineStart;
            int valueSize = 0;
            int escapeCount = 0;
            int columnIndex = 0;
            for (int i = this.lineStart; i < this.lineEnd; ++i) {
                byte ch;
                block27: {
                    block30: {
                        ch = this.buf[i];
                        if (!quote) break block30;
                        if (ch == 34) {
                            int n = i + 1;
                            if (n < this.lineEnd) {
                                byte c1 = this.buf[n];
                                if (c1 == 34) {
                                    valueSize += 2;
                                    ++escapeCount;
                                    ++i;
                                    continue;
                                }
                                if (c1 == 44) {
                                    ++i;
                                    ch = c1;
                                }
                                break block27;
                            } else if (n == this.lineEnd) {
                                break;
                            }
                            break block27;
                        } else {
                            ++valueSize;
                            continue;
                        }
                    }
                    if (ch == 34) {
                        quote = true;
                        continue;
                    }
                }
                if (ch == 44) {
                    if (quote) {
                        if (escapeCount == 0) {
                            consumer.accept(this.rowCount, columnIndex, this.buf, valueStart + 1, valueSize, this.charset);
                        } else {
                            byte[] bytes = new byte[valueSize - escapeCount];
                            int valueEnd = valueStart + valueSize;
                            int k = 0;
                            for (int j = valueStart + 1; j < valueEnd; ++j) {
                                byte c = this.buf[j];
                                bytes[k++] = c;
                                if (c != 34 || this.buf[j + 1] != 34) continue;
                                ++j;
                            }
                            consumer.accept(this.rowCount, columnIndex, bytes, 0, bytes.length, this.charset);
                        }
                    } else {
                        consumer.accept(this.rowCount, columnIndex, this.buf, valueStart, valueSize, this.charset);
                    }
                    quote = false;
                    valueStart = i + 1;
                    valueSize = 0;
                    escapeCount = 0;
                    ++columnIndex;
                    continue;
                }
                ++valueSize;
            }
            if (valueSize > 0) {
                if (quote) {
                    if (escapeCount == 0) {
                        consumer.accept(this.rowCount, columnIndex, this.buf, valueStart + 1, valueSize, this.charset);
                    } else {
                        byte[] bytes = new byte[valueSize - escapeCount];
                        int valueEnd = this.lineEnd;
                        int k = 0;
                        for (int j = valueStart + 1; j < valueEnd; ++j) {
                            byte c = this.buf[j];
                            bytes[k++] = c;
                            if (c != 34 || this.buf[j + 1] != 34) continue;
                            ++j;
                        }
                        consumer.accept(this.rowCount, columnIndex, bytes, 0, bytes.length, this.charset);
                    }
                } else {
                    consumer.accept(this.rowCount, columnIndex, this.buf, valueStart, valueSize, this.charset);
                }
            }
            consumer.afterRow(this.rowCount);
        }
    }
}

