/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.prometheus.agent.util;

import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;

public class CommitPoolUtil {
    public static ScheduledThreadPoolExecutor PROMETHEUS_LOCAL_CONFIG_POOL;
    public static ScheduledThreadPoolExecutor PROMETHEUS_COMPARE_RELOAD_POOL;
    public static ScheduledThreadPoolExecutor ALERTMANAGER_LOCAL_CONFIG_POOL;
    public static ScheduledThreadPoolExecutor ALERTMANAGER_COMPARE_RELOAD_POOL;
    private static final AtomicInteger threadNumber;

    static {
        threadNumber = new AtomicInteger(1);
        try {
            PROMETHEUS_LOCAL_CONFIG_POOL = new ScheduledThreadPoolExecutor(1, r -> {
                Thread thread = new Thread(r);
                thread.setDaemon(false);
                thread.setName("prometheusClient-local-config-" + threadNumber.getAndIncrement());
                return thread;
            }, new ThreadPoolExecutor.CallerRunsPolicy());
            PROMETHEUS_COMPARE_RELOAD_POOL = new ScheduledThreadPoolExecutor(1, r -> {
                Thread thread = new Thread(r);
                thread.setDaemon(false);
                thread.setName("prometheusClient-compare-reload-" + threadNumber.getAndIncrement());
                return thread;
            }, new ThreadPoolExecutor.CallerRunsPolicy());
            ALERTMANAGER_LOCAL_CONFIG_POOL = new ScheduledThreadPoolExecutor(1, r -> {
                Thread thread = new Thread(r);
                thread.setDaemon(false);
                thread.setName("alertManagerClient-local-config-" + threadNumber.getAndIncrement());
                return thread;
            }, new ThreadPoolExecutor.CallerRunsPolicy());
            ALERTMANAGER_COMPARE_RELOAD_POOL = new ScheduledThreadPoolExecutor(1, r -> {
                Thread thread = new Thread(r);
                thread.setDaemon(false);
                thread.setName("alertManagerClient-compare-reload-" + threadNumber.getAndIncrement());
                return thread;
            }, new ThreadPoolExecutor.CallerRunsPolicy());
        }
        catch (Throwable e) {
            System.out.println("CommitPoolUtil static error :" + e.getMessage());
        }
    }
}

