/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.prometheus.agent.util;

import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtil {
    private static final Logger log = LoggerFactory.getLogger(DateUtil.class);

    public static String Time2YYMMdd(String inputDate) {
        SimpleDateFormat inputFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy", Locale.US);
        SimpleDateFormat outputFormat = new SimpleDateFormat("yyyy-MM-dd-HH:mm:ss", Locale.CHINA);
        Date date = inputFormat.parse(inputDate);
        String outputDate = outputFormat.format(date);
        return outputDate;
    }

    public static String TimeStampToISO8601UTC(long timeStamp) {
        SimpleDateFormat sdf = new SimpleDateFormat("YYYY-MM-dd'T'HH:MM:ss.sss'Z'");
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        String utcTime = sdf.format(new Date(timeStamp));
        return utcTime;
    }

    public static long ISO8601UTCTOTimeStamp(String utcTime) {
        try {
            Instant instant = Instant.parse(utcTime);
            return instant.toEpochMilli();
        }
        catch (DateTimeParseException e) {
            int lastDotIndex = utcTime.lastIndexOf(46);
            if (lastDotIndex != -1) {
                String dateTimeStringWithoutMillis = utcTime.substring(0, lastDotIndex) + "Z";
                try {
                    Instant instant = Instant.parse(dateTimeStringWithoutMillis);
                    return instant.toEpochMilli();
                }
                catch (DateTimeParseException ex) {
                    log.info("parse time string fail\uff1a" + ex.getMessage());
                }
            }
            log.info("parse time string fail\uff1a" + e.getMessage());
            return -1L;
        }
    }

    public static String ISO8601UTCTOCST(String utcTime) {
        try {
            Instant instant = Instant.parse(utcTime);
            ZonedDateTime zonedDateTime = instant.atZone(ZoneId.of("Asia/Shanghai"));
            LocalDateTime localDateTime = zonedDateTime.toLocalDateTime();
            return String.valueOf(localDateTime);
        }
        catch (DateTimeParseException e) {
            log.info("parse time string fail \uff1a" + e.getMessage());
            return null;
        }
    }
}

